package cn.com.duibaboot.ext.autoconfigure.perftest;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.nio.file.Files;
import java.util.Collections;

import cn.com.duibaboot.ext.autoconfigure.plugin.AbstractClassEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.plugin.PluginBootstrap;
import cn.com.duibaboot.ext.autoconfigure.plugin.PluginFinder;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 查找agent-plugin下配置的插件进行拦截,注入代码到相应的类
 */
public class PluginAgent {
    private static final Logger logger = LoggerFactory.getLogger(PluginAgent.class);

    public static void agentmain(String args, Instrumentation instrumentation) throws IOException {
        File temp = Files.createTempDirectory("tmp").toFile();
        ClassInjector.UsingInstrumentation.of(temp, ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, instrumentation).inject(Collections.singletonMap(
                new TypeDescription.ForLoadedType(PluginAgent.class),
                ClassFileLocator.ForClassLoader.read(PluginAgent.class).resolve()));
        final PluginFinder pluginFinder = new PluginFinder(new PluginBootstrap().loadPlugins());
        new AgentBuilder.Default().ignore(ElementMatchers.nameStartsWith("net.bytebuddy."))
                .enableBootstrapInjection(instrumentation, temp).type(pluginFinder.buildMatch()).transform(new AgentBuilder.Transformer() {
            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription,
                                                    ClassLoader classLoader, JavaModule module) {
                AbstractClassEnhancePluginDefine pluginDefine = pluginFinder.find(typeDescription, classLoader);
                if (pluginDefine != null) {
                    DynamicType.Builder<?> newBuilder = pluginDefine.define(typeDescription.getTypeName(), builder, classLoader);
                    if (newBuilder != null) {
                        logger.info("Finish the prepare stage for {}.", typeDescription.getName());
                        return newBuilder;
                    }
                }

                logger.info("Matched class " + typeDescription.getTypeName() + ", but ignore by finding mechanism.");
                return builder;
            }
        }).with(new AgentBuilder.Listener() {
            @Override
            public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {

            }

            @Override
            public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module,
                                         boolean loaded, DynamicType dynamicType) {
                logger.info("On Transformation class {}.", typeDescription.getName());
            }

            @Override
            public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module,
                                  boolean loaded) {

            }

            @Override
            public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded,
                                Throwable throwable) {
                logger.info("Failed to enhance class " + typeName, throwable);
            }

            @Override
            public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
            }
        }).installOn(instrumentation);
    }
}