package cn.com.duibaboot.ext.autoconfigure.perftest;

import java.util.concurrent.ConcurrentHashMap;

import com.mongodb.MongoClientURI;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;

/**
 * 加入AOP，压测时mongodb的读写流量走影子库
 */
@Aspect
public class SpringDataMongodbPerfAspect {
    private static final Logger logger = LoggerFactory.getLogger(SpringDataMongodbPerfAspect.class);
    public static ConcurrentHashMap<String,String> OriginDataBaseUri=new ConcurrentHashMap<>();
    private ConcurrentHashMap<String,MongoTemplate> mongoTemplateConcurrentHashMap=new ConcurrentHashMap<>();

    /**
     * 拦截测试请求,修改使用影子库
     *
     * @param joinPoint
     * @return
     * @throws Throwable
     */
    @Around("execution(* org.springframework.data.mongodb.core.MongoTemplate.*(..))")
    public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        MongoTemplate origin = (MongoTemplate) joinPoint.getTarget();
        Object[] args = joinPoint.getArgs();
        String dbName=origin.getDb().getName();
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            if (!mongoTemplateConcurrentHashMap.containsKey(dbName)) {
                MongoClientURI mongoClientURI=  new MongoClientURI(OriginDataBaseUri.get(dbName));
                String originDataBaseName=mongoClientURI.getDatabase();
                SimpleMongoDbFactory shadeFactory= new SimpleMongoDbFactory(new MongoClientURI(OriginDataBaseUri.get(dbName).replace("/"+originDataBaseName+"?","/"+PerfTestRoutingDataSource.TEST_SCHEME_PREFIX+originDataBaseName+"?")));
                mongoTemplateConcurrentHashMap.put(dbName,new MongoTemplate(shadeFactory));
            }
            PerfTestContext.debugInfo("MongoTemplate");
            return signature.getMethod().invoke(mongoTemplateConcurrentHashMap.get(dbName), args);
        } else {
            return joinPoint.proceed(args);
        }
    }

}
