package cn.com.duibaboot.ext.autoconfigure.perftest.rocketmq;


import static cn.com.duibaboot.ext.autoconfigure.plugin.match.HierarchyMatch.byHierarchyMatch;
import static net.bytebuddy.matcher.ElementMatchers.nameStartsWith;
import static net.bytebuddy.matcher.ElementMatchers.named;

import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.ConstructorInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.InstanceMethodsInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.ClassInstanceMethodsEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.plugin.match.ClassMatch;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;

/**
 * 拦截guava的CacheLoader的实现类,方法执行前设置PerfTestMode为false，保证所有的是缓存回源都是正式数据,防止影响线上服务器的内存数据
 */
public class RocketMqInstrumentation extends ClassInstanceMethodsEnhancePluginDefine {

    private static final String ENHANCE_CLASS = "org.apache.rocketmq.client.producer.DefaultMQProducer";
    private static final String INTERCEPT_CLASS = RocketMqInterceptor.class.getName();

    @Override
    protected ClassMatch enhanceClass() {
        String[] parentType=new String[]{ENHANCE_CLASS};
        return byHierarchyMatch(parentType);
    }

    @Override
    protected ConstructorInterceptPoint[] getConstructorsInterceptPoints() {
        return null;
    }

    @Override
    protected InstanceMethodsInterceptPoint[] getInstanceMethodsInterceptPoints() {
        return new InstanceMethodsInterceptPoint[] {
            new InstanceMethodsInterceptPoint() {
                @Override
                public ElementMatcher<MethodDescription> getMethodsMatcher() {
                    return nameStartsWith("send");
                }

                @Override
                public String getMethodsInterceptor() {
                    return INTERCEPT_CLASS;
                }

                @Override
                public boolean isOverrideArgs() {
                    return true;
                }
            }
        };
    }
}
