package cn.com.duibaboot.ext.autoconfigure.perftest.rocketmq;

import java.lang.reflect.Method;

import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.EnhancedInstance;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.MethodInterceptResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 拦截guava的CacheLoader的实现类,方法执行前设置PerfTestMode为false，保证所有的是缓存回源(比如数据库、mongodb等)都是正式数据,防止影响线上服务器的内存数据
 */
public class RocketMqInterceptor implements InstanceMethodsAroundInterceptor {
    private final Logger logger = LoggerFactory.getLogger(RocketMqInterceptor.class);

    @Override
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments,
                             Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        boolean isPerf = PerfTestContext.isCurrentInPerfTestMode();
        if (isPerf) {
            if (allArguments[0] instanceof org.apache.rocketmq.common.message.Message) {
                ((org.apache.rocketmq.common.message.Message) allArguments[0]).putUserProperty("perftest", "true");
            }
        }
    }

    @Override
    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments,
                              Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    @Override
    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments,
                                      Class<?>[] argumentsTypes, Throwable t) {
    }
}
