/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.core.rpc;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class RpcContext
implements Cloneable {
    private static final ThreadLocal<RpcContext> LOCAL = new ThreadLocal<RpcContext>(){

        @Override
        protected RpcContext initialValue() {
            return new RpcContext();
        }
    };
    private Method method;
    private final Map<String, String> attachments = new HashMap<String, String>();
    private final Map<String, Object> values = new HashMap<String, Object>();

    public static RpcContext getContext() {
        return LOCAL.get();
    }

    public static void setContext(RpcContext rpcContext) {
        LOCAL.set(rpcContext);
    }

    public static void removeContext() {
        LOCAL.remove();
    }

    protected RpcContext() {
    }

    public RpcContext clone() {
        RpcContext nr = new RpcContext();
        nr.getAttachments().putAll(this.getAttachments());
        nr.get().putAll(this.get());
        nr.setMethod(this.getMethod());
        return nr;
    }

    public String getAttachment(String key) {
        return this.attachments.get(key);
    }

    public RpcContext setAttachment(String key, String value) {
        if (value == null) {
            this.attachments.remove(key);
        } else {
            this.attachments.put(key, value);
        }
        return this;
    }

    public RpcContext removeAttachment(String key) {
        this.attachments.remove(key);
        return this;
    }

    public Map<String, String> getAttachments() {
        return this.attachments;
    }

    public RpcContext setAttachments(Map<String, String> attachment) {
        this.attachments.clear();
        if (attachment != null && attachment.size() > 0) {
            this.attachments.putAll(attachment);
        }
        return this;
    }

    public void clearAttachments() {
        this.attachments.clear();
    }

    public Map<String, Object> get() {
        return this.values;
    }

    public RpcContext set(String key, Object value) {
        if (value == null) {
            this.values.remove(key);
        } else {
            this.values.put(key, value);
        }
        return this;
    }

    public RpcContext remove(String key) {
        this.values.remove(key);
        return this;
    }

    public Object get(String key) {
        return this.values.get(key);
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }
}

