/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.hbase;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.data.hadoop.hbase.HbaseConfigurationFactoryBean;

@ConfigurationProperties(prefix="duiba.hbase")
public class HbaseProperties {
    private String zkQuorum;
    private Integer zkPort;
    private Integer rpcTimeout = 5000;
    private Integer operationTimeout = 10000;
    private Integer pause = 20;
    private Integer retriesNumber = 10;
    private Integer scannerTimeoutPeriod = 60000;
    private Properties properties;
    private Configuration configuration;

    public String getZkQuorum() {
        return this.zkQuorum;
    }

    public void setZkQuorum(String zkQuorum) {
        this.zkQuorum = zkQuorum;
    }

    public Integer getZkPort() {
        return this.zkPort;
    }

    public void setZkPort(Integer zkPort) {
        this.zkPort = zkPort;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Integer getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(Integer operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public Integer getRpcTimeout() {
        return this.rpcTimeout;
    }

    public void setRpcTimeout(Integer rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
    }

    public Integer getPause() {
        return this.pause;
    }

    public void setPause(Integer pause) {
        this.pause = pause;
    }

    public Integer getRetriesNumber() {
        return this.retriesNumber;
    }

    public void setRetriesNumber(Integer retriesNumber) {
        this.retriesNumber = retriesNumber;
    }

    public Integer getScannerTimeoutPeriod() {
        return this.scannerTimeoutPeriod;
    }

    public void setScannerTimeoutPeriod(Integer scannerTimeoutPeriod) {
        this.scannerTimeoutPeriod = scannerTimeoutPeriod;
    }

    public synchronized Configuration getConfiguration() {
        if (this.configuration == null) {
            HbaseConfigurationFactoryBean config = new HbaseConfigurationFactoryBean();
            config.setZkQuorum(this.getZkQuorum());
            config.setZkPort(this.getZkPort());
            config.setProperties(this.properties);
            config.afterPropertiesSet();
            this.configuration = config.getObject();
        }
        return this.configuration;
    }
}

