/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.graceclose;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import cn.com.duibaboot.ext.autoconfigure.graceclose.DuibaBootBanner;
import cn.com.duibaboot.ext.autoconfigure.web.BootMonitorCheckFilter;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.netflix.discovery.EurekaClient;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class GracefulCloseRunListener
implements SpringApplicationRunListener {
    private static final Logger logger = LoggerFactory.getLogger(GracefulCloseRunListener.class);
    private SpringApplication application;
    private static boolean startingCalled = false;

    public GracefulCloseRunListener(SpringApplication application, String[] args) {
        this.application = application;
    }

    public void started() {
    }

    public void starting() {
        if (!startingCalled) {
            startingCalled = true;
            this.application.setBannerMode(Banner.Mode.OFF);
            new DuibaBootBanner().printBanner(System.out);
        }
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
    }

    public void finished(final ConfigurableApplicationContext context, Throwable exception) {
        if (context == null || !(context instanceof EmbeddedWebApplicationContext)) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("java.lang.ApplicationShutdownHooks");
            Field field = clazz.getDeclaredField("hooks");
            field.setAccessible(true);
            IdentityHashMap hooks = (IdentityHashMap)field.get(null);
            ArrayList keys2remove = new ArrayList();
            for (Map.Entry entry : hooks.entrySet()) {
                String hookClassName = ((Thread)entry.getKey()).getClass().getName();
                if (hookClassName.equals("java.util.logging.LogManager$Cleaner") || hookClassName.equals("org.unidal.helper.Threads$Manager$1") || hookClassName.startsWith("org.jacoco.agent.rt") || hookClassName.startsWith("org.quartz")) continue;
                logger.debug("remove shotdownhook:{}", (Object)hookClassName);
                keys2remove.add(entry.getKey());
            }
            for (Thread t : keys2remove) {
                hooks.remove(t);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    long start = System.currentTimeMillis();
                    if (!logger.isInfoEnabled()) {
                        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                        loggerContext.getLogger(GracefulCloseRunListener.class).setLevel(Level.INFO);
                    }
                    logger.info("begin to shutdown server...");
                    logger.info("disable /monitor/check");
                    BootMonitorCheckFilter.setInService(false);
                    try {
                        Class.forName("com.netflix.discovery.EurekaClient");
                        EurekaClient eurekaClient = (EurekaClient)context.getBean(EurekaClient.class);
                        if (eurekaClient != null) {
                            logger.info("unregister from eureka-server");
                            eurekaClient.shutdown();
                        }
                    }
                    catch (ClassNotFoundException | NoSuchBeanDefinitionException eurekaClient) {
                        // empty catch block
                    }
                    try {
                        Class.forName("com.alibaba.dubbo.config.ProtocolConfig");
                        logger.info("clean up dubbo");
                        ProtocolConfig.destroyAll();
                    }
                    catch (ClassNotFoundException | ExceptionInInitializerError e) {
                        logger.info("\u8be5\u9879\u76ee\u6ca1\u6709\u5f15\u5165dubbo\uff0c\u4e0d\u4f1a\u6267\u884cdubbo\u6e05\u7406");
                    }
                    catch (Throwable e) {
                        logger.error(e.getMessage(), e);
                    }
                    logger.info("clean up spring");
                    try {
                        context.close();
                    }
                    catch (Throwable e) {
                        logger.error(e.getMessage(), e);
                    }
                    long period = System.currentTimeMillis() - start;
                    logger.info("shutdown server finished successfully\uff0ccost\uff1a{} ms", (Object)period);
                    LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                    loggerContext.stop();
                }
            });
        }
        catch (IllegalStateException clazz) {
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

