/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.cloud.netflix.feign.hystrix;

import cn.com.duiba.boot.ext.autoconfigure.cloud.netflix.feign.hystrix.FeignErrorDecoder;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixCommand;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixThreadPoolKey;
import feign.Feign;
import feign.RetryableException;
import feign.Retryer;
import feign.Target;
import feign.codec.ErrorDecoder;
import feign.hystrix.HystrixFeign;
import feign.hystrix.SetterFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@ConditionalOnClass(value={HystrixCommand.class, HystrixFeign.class})
public class HystrixFeignConfiguration {
    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"feign.hystrix.enabled"}, matchIfMissing=true)
    public Feign.Builder feignHystrixBuilder() {
        return HystrixFeign.builder().setterFactory((SetterFactory)new HystrixFeignSetterFactory());
    }

    @Bean
    public ErrorDecoder feignErrorDecoder() {
        return new FeignErrorDecoder();
    }

    final class HystrixFeignSetterFactory
    implements SetterFactory {
        HystrixFeignSetterFactory() {
        }

        public HystrixCommand.Setter create(Target<?> target, Method method) {
            String defaultGroupKey = target.name();
            String defaultCommandKey = Feign.configKey((Class)target.type(), (Method)method);
            FeignHystrixCommand methodCommand = method.getAnnotation(FeignHystrixCommand.class);
            Object[] methodProperties = (FeignHystrixProperty[])method.getAnnotationsByType(FeignHystrixProperty.class);
            FeignHystrixCommand classCommand = target.type().getAnnotation(FeignHystrixCommand.class);
            Object[] classProperties = (FeignHystrixProperty[])target.type().getAnnotationsByType(FeignHystrixProperty.class);
            ArrayList<FeignHystrixCommand> commands = new ArrayList<FeignHystrixCommand>();
            commands.add(methodCommand);
            commands.add(classCommand);
            String groupKey = commands.stream().filter(c -> c != null && StringUtils.isNotBlank((String)c.groupKey())).findFirst().map(c -> c.groupKey()).orElse(defaultGroupKey);
            String commandKey = methodCommand == null || StringUtils.isBlank((String)methodCommand.commandKey()) ? defaultCommandKey : methodCommand.commandKey();
            String threadPoolKey = commands.stream().filter(c -> c != null && StringUtils.isNotBlank((String)c.threadPoolKey())).findFirst().map(c -> c.threadPoolKey()).orElse(null);
            HystrixCommand.Setter setter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)groupKey));
            setter.andCommandKey(HystrixCommandKey.Factory.asKey((String)commandKey));
            if (threadPoolKey != null) {
                setter.andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)threadPoolKey));
            }
            ArrayList<Object> allProperties = new ArrayList<Object>();
            if (classCommand != null && !ArrayUtils.isEmpty((Object[])classCommand.properties())) {
                for (FeignHystrixProperty feignHystrixProperty : classCommand.properties()) {
                    allProperties.add(feignHystrixProperty);
                }
            }
            if (!ArrayUtils.isEmpty((Object[])classProperties)) {
                for (Object object : classProperties) {
                    allProperties.add(object);
                }
            }
            if (methodCommand != null && !ArrayUtils.isEmpty((Object[])methodCommand.properties())) {
                for (FeignHystrixProperty feignHystrixProperty : methodCommand.properties()) {
                    allProperties.add(feignHystrixProperty);
                }
            }
            if (!ArrayUtils.isEmpty((Object[])methodProperties)) {
                for (Object object : methodProperties) {
                    allProperties.add(object);
                }
            }
            setter.andCommandPropertiesDefaults(HystrixPropertiesManager.initializeCommandProperties(allProperties));
            setter.andThreadPoolPropertiesDefaults(HystrixPropertiesManager.initializeThreadPoolProperties(allProperties));
            return setter;
        }
    }

    @Configuration
    public static class CustomRetryer
    implements Retryer {
        private int maxAttempts = 2;
        private int attempt = 1;

        public void continueOrPropagate(RetryableException e) {
            if (this.attempt++ >= this.maxAttempts) {
                throw e;
            }
            Throwable cause = e.getCause();
            if (cause == null) {
                throw e;
            }
            if (cause instanceof RejectedExecutionException) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            } else {
                throw e;
            }
        }

        public Retryer clone() {
            return new CustomRetryer();
        }
    }
}

