/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.core.utils;

import cn.com.duiba.catmonitor.CatInstance;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatUtils {
    private static final Logger logger = LoggerFactory.getLogger(CatUtils.class);

    private CatUtils() {
    }

    public static void completeTransaction(Transaction transaction) {
        if (logger.isDebugEnabled()) {
            MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
            String messageId = tree.getMessageId();
            if (messageId == null) {
                messageId = Cat.createMessageId();
                tree.setMessageId(messageId);
            }
            CatUtils.printTransactionLog(transaction, tree);
        }
        transaction.complete();
    }

    private static void printTransactionLog(Transaction t, MessageTree tree) {
        if (logger.isDebugEnabled()) {
            logger.debug("mid:{},Cat_type:{},name:{},pid:{},rid:{},thread:{},created:{}", new Object[]{tree.getMessageId(), t.getType(), t.getName(), tree.getParentMessageId(), tree.getRootMessageId(), tree.getThreadName(), t.getTimestamp()});
        }
    }

    public static boolean isCatEnabled() {
        try {
            Class.forName("cn.com.duiba.catmonitor.CatInstance");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return CatInstance.isEnable();
    }
}

