/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.initserver;

import cn.com.duiba.boot.ext.autoconfigure.core.AsyncSpecifiedBeanPostProcessor;
import cn.com.duiba.boot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public class BeanPostProcessorOfSpecified
implements BeanPostProcessor,
Ordered {
    private List<SpecifiedBeanPostProcessor> processorList;
    private List<AsyncSpecifiedBeanPostProcessor> asyncProcessorList;
    private Map<AsyncSpecifiedBeanPostProcessor, Map<String, Object>> asyncProcessor2BeansMap;

    public BeanPostProcessorOfSpecified(List<SpecifiedBeanPostProcessor> processorList, List<AsyncSpecifiedBeanPostProcessor> asyncProcessorList, Map<AsyncSpecifiedBeanPostProcessor, Map<String, Object>> asyncProcessor2BeansMap) {
        this.processorList = processorList;
        this.asyncProcessorList = asyncProcessorList;
        this.asyncProcessor2BeansMap = asyncProcessor2BeansMap;
    }

    public int getOrder() {
        return -2;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        for (SpecifiedBeanPostProcessor p : this.processorList) {
            if (!p.getBeanType().isAssignableFrom(bean.getClass())) continue;
            bean = p.postProcessBeforeInitialization(bean, beanName);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        for (SpecifiedBeanPostProcessor p : this.processorList) {
            if (!p.getBeanType().isAssignableFrom(bean.getClass())) continue;
            bean = p.postProcessAfterInitialization(bean, beanName);
        }
        for (AsyncSpecifiedBeanPostProcessor asyncProcessor : this.asyncProcessorList) {
            if (!asyncProcessor.getBeanType().isAssignableFrom(bean.getClass())) continue;
            Map<String, Object> beanMap = this.asyncProcessor2BeansMap.get(asyncProcessor);
            if (beanMap == null) {
                beanMap = new HashMap<String, Object>();
                this.asyncProcessor2BeansMap.put(asyncProcessor, beanMap);
            }
            beanMap.put(beanName, bean);
        }
        return bean;
    }
}

