/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.web;

import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;

public class BootMonitorCheckFilter
implements Filter {
    private static volatile boolean inService = false;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String uri = request.getRequestURI();
        if (uri.equals("/monitor/check")) {
            if (!inService) {
                response.setStatus(HttpStatus.SERVICE_UNAVAILABLE.value());
            }
            response.getWriter().write(inService ? "OK" : "INVALID");
        } else if (uri.equals("/monitor/stop")) {
            if (!this.isLocalRequest(request)) {
                response.getWriter().write("NO PERMISSION");
                return;
            }
            inService = false;
            response.getWriter().write("OK");
        } else if (uri.equals("/monitor/start")) {
            if (!this.isLocalRequest(request)) {
                response.getWriter().write("NO PERMISSION");
                return;
            }
            inService = true;
            response.getWriter().write("OK");
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private boolean isLocalRequest(HttpServletRequest request) {
        boolean isFromLocalIp = RequestTool.isLocalRequest((HttpServletRequest)request);
        if (!isFromLocalIp) {
            return false;
        }
        boolean isUrlFromLocal = false;
        try {
            URL url = new URL(request.getRequestURL().toString());
            if (url.getHost().equals("localhost") || url.getHost().equals("127.0.0.1")) {
                isUrlFromLocal = true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return isUrlFromLocal;
    }

    public void destroy() {
    }

    public static void setInService(boolean inService) {
        BootMonitorCheckFilter.inService = inService;
    }
}

