/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.web;

import cn.com.duiba.boot.ext.autoconfigure.core.DuibaServerProperties;
import cn.com.duiba.boot.ext.autoconfigure.web.FailFastFilter;
import cn.com.duiba.boot.ext.autoconfigure.web.ThreadPoolServletContainerCustomizer;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Resource;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={DuibaServerProperties.class})
public class DuibaEmbeddedServletContainerAutoConfiguration {
    @Resource
    private DuibaServerProperties duibaServerProperties;

    @Bean
    public ThreadPoolServletContainerCustomizer getThreadPoolServletContainerCustomizer() {
        return new ThreadPoolServletContainerCustomizer(this.duibaServerProperties);
    }

    @Bean
    public FilterRegistrationBean getFailFastFilter() {
        FailFastFilter filter = new FailFastFilter();
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)filter);
        ArrayList<String> urlPatterns = new ArrayList<String>();
        urlPatterns.add("/*");
        registrationBean.setUrlPatterns(urlPatterns);
        registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
        registrationBean.setOrder(Integer.MIN_VALUE);
        return registrationBean;
    }
}

