package cn.com.duiba.boot.ext.autoconfigure.cloud.netflix.feign;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;

import java.util.Collections;
import java.util.Set;

/**
 * 转换器，把Object转换为JSON，使用fastjson
 * Created by wenqi.huang on 2017/8/2.
 */
public class ObjectToJsonStringConverter implements ConditionalGenericConverter {

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Class clazz = targetType.getType();
        if(clazz.equals(String.class)){
            return true;
        }

        return false;
    }

    @Override
    public Set<ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new ConvertiblePair(Object.class, String.class));
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return JSON.toJSONString(source);//SerializerFeature.WriteClassName 这个用于指定序列化时要不要加入类名。
    }
}
