package cn.com.duibaboot.ext.autoconfigure.profiler;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

/**
 * 自动配置DBTimeProfiler,自动给注解了@DBTimeProfiler的方法增加耗时监控，超时的时候打印超时WARN日志.
 */
@Configuration
@EnableAspectJAutoProxy(proxyTargetClass = true)
@ConditionalOnClass(DBTimeProfile.class)
public class TimeProfilerAutoConfiguration {

    @Bean
    public TimeProfileAspect timeProfileAspect(){
        return new TimeProfileAspect();
    }
}
