/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.hbase;

import cn.com.duibaboot.ext.autoconfigure.data.hbase.HTableConnectionFactory;
import cn.com.duibaboot.ext.autoconfigure.data.hbase.HbaseProperties;
import cn.com.duibaboot.ext.autoconfigure.data.hbase.WrappedHbaseTemplate;
import javax.annotation.Resource;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterfaceFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.hadoop.hbase.HbaseTemplate;

@Configuration
@ConditionalOnClass(value={HbaseTemplate.class, HTable.class})
@EnableConfigurationProperties(value={HbaseProperties.class})
public class HbaseAutoConfiguration {
    @Resource
    private HbaseProperties hbaseProperties;

    @Bean
    @ConditionalOnMissingBean(value={HTableInterfaceFactory.class})
    public HTableInterfaceFactory hTableInterfaceFactory() {
        org.apache.hadoop.conf.Configuration configuration = this.hbaseProperties.getConfiguration();
        return new HTableConnectionFactory(configuration);
    }

    @Bean
    @ConditionalOnMissingBean(value={HbaseTemplate.class})
    public HbaseTemplate hbaseTemplate(HTableInterfaceFactory hTableInterfaceFactory) {
        org.apache.hadoop.conf.Configuration configuration = this.hbaseProperties.getConfiguration();
        WrappedHbaseTemplate hbaseTemplate = new WrappedHbaseTemplate(configuration);
        hbaseTemplate.setTableFactory(hTableInterfaceFactory);
        return hbaseTemplate;
    }
}

