/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.httpclient;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={HttpClient.class})
@AutoConfigureBefore(name={"org.springframework.cloud.netflix.feign.ribbon.FeignRibbonClientAutoConfiguration"})
public class HttpClientAutoConfiguration {
    @Bean(name={"httpClient"}, destroyMethod="close")
    public CloseableHttpClient httpClient() {
        return HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(60000).setConnectionRequestTimeout(10).build()).setMaxConnPerRoute(100).setUserAgent("Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36").disableAutomaticRetries().disableCookieManagement().useSystemProperties().setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long time = super.getKeepAliveDuration(response, context);
                if (time == -1L) {
                    time = 30000L;
                }
                return time;
            }
        }).build();
    }

    public static void main(String[] args) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(60000).setConnectionRequestTimeout(10).build()).setMaxConnPerRoute(100).setUserAgent("Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36").disableAutomaticRetries().disableCookieManagement().useSystemProperties().setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long time = super.getKeepAliveDuration(response, context);
                if (time == -1L) {
                    time = 30000L;
                }
                return time;
            }
        }).build();
    }
}

