package cn.com.duibaboot.ext.autoconfigure.core.utils;

import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import sun.net.util.IPAddressUtil;

import javax.servlet.http.HttpServletRequest;
import java.net.MalformedURLException;
import java.net.URL;

public class HttpRequestUtils {

    /**
     * 访问的来源ip必须是127.0.0.1， 并且访问的url也必须是127.0.0.1
     * @param request
     * @return
     */
    public static boolean isLocalRequest(HttpServletRequest request){
        boolean isFromLocalIp = RequestTool.isLocalRequest(request);
        if(!isFromLocalIp){
            return false;
        }

        //ip有可能是伪造的，故需要结合host一起判断
        boolean isUrlFromLocal = false;
        try {
            URL url = new URL(request.getRequestURL().toString());
            if(url.getHost().equals("localhost") || url.getHost().equals("127.0.0.1")) {
                isUrlFromLocal = true;
            }
        } catch (MalformedURLException e) {
            // Ignore
        }

        return isUrlFromLocal;
    }

    /**
     * 访问的来源ip必须在内网
     * @param request
     * @return
     */
    public static boolean isLanRequest(HttpServletRequest request){
        String ip = RequestTool.getIpAddr(request);
        boolean isLanIp = false;
        if (ip.equals("127.0.0.1") || ip.equals("0:0:0:0") || isLanIp(ip)) {
            isLanIp = true;
        }
        if(!isLanIp){
            return false;
        }

        //ip有可能是伪造的，故需要结合host一起判断
        boolean isUrlFromLan = false;
        try {
            URL url = new URL(request.getRequestURL().toString());
            String urlHost = url.getHost();
            if (urlHost.equals("127.0.0.1") || urlHost.equals("localhost") || isLanIp(urlHost)) {
                isUrlFromLan = true;
            }
        } catch (MalformedURLException e) {
            // Ignore
        }

        return isUrlFromLan;
    }

    /**
     * 判断是否内网ip：以下范围的属于内网IP：<br/>
     * 10.0.0.0~10.255.255.255（A类）<br/>
     * 172.16.0.0~172.31.255.255（B类）<br/>
     * 192.168.0.0~192.168.255.255（C类）<br/>
     *
     * @param ip
     * @return
     */
    protected static boolean isLanIp(String ip) {
        byte[] addr = IPAddressUtil.textToNumericFormatV4(ip);
        return isLanIp(addr);
    }


    private static boolean isLanIp(byte[] addr) {
        final byte b0 = addr[0];
        final byte b1 = addr[1];
        //10.x.x.x/8
        final byte SECTION_1 = 0x0A;
        //172.16.x.x/12
        final byte SECTION_2 = (byte) 0xAC;
        final byte SECTION_3 = (byte) 0x10;
        final byte SECTION_4 = (byte) 0x1F;
        //192.168.x.x/16
        final byte SECTION_5 = (byte) 0xC0;
        final byte SECTION_6 = (byte) 0xA8;
        switch (b0) {
            case SECTION_1:
                return true;
            case SECTION_2:
                if (b1 >= SECTION_3 && b1 <= SECTION_4) {
                    return true;
                }
            case SECTION_5:
                switch (b1) {
                    case SECTION_6:
                        return true;
                }
            default:
                return false;

        }
    }
}
