package cn.com.duibaboot.ext.autoconfigure.core;

/**
 * 这个类的实例会被ApplicationListener调用,参见InitServerAutoConfiguration.asyncSpecifiedBeanPostProcessorConfigurer
 * 和SpecifiedBeanPostProcessor的区别是这个本处理器是异步执行的，但是仍然需要等所有处理器都执行成功了才会让spring启动成功;另外本处理器不能改变bean的引用
 * Created by wenqi.huang on 2017/6/14.
 */
public interface AsyncSpecifiedBeanPostProcessor<T> {

    /**
     * 需要处理的Bean类
     * @return
     */
    Class<T> getBeanType();

    void postProcessAfterInitialization(T bean, String beanName);

}
