package cn.com.duibaboot.ext.autoconfigure.core;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="duiba.server")
public class DuibaServerProperties {
    /**
     * 是否内部服务，默认false，如果指定了是内部服务，则会自动配置一些针对内部服务的优化，目前主要有：<br/>
     * 1.配置jackson序列化时不序列化为null的值（对应的key也不会输出），以减小网络传输量<br/>
     * 2.配置tomcat的线程池以适合REST RPC调用：最小和最大线程数调成一样（使用server.tomcat.max-threads配置来控制），并使队列数为0（failfast，服务器忙时抛出RejectedExecutionException，让客户端判断到此异常从而尽快到其他服务器重试）<br/>
     * 区分是否内部服务的方式：一般提供内部REST风格RPC接口的都是内部服务，比对service层、center层；直接向外提供web服务的都不是内部服务，比如web层。
     */
    private boolean internalMode;

    public boolean isInternalMode() {
        return internalMode;
    }

    public void setInternalMode(boolean internalMode) {
        this.internalMode = internalMode;
    }
}
