package cn.com.duibaboot.ext.autoconfigure.core.utils;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class SpringBootUtils {

    private static final Set<String> SKIPPED_STACK_ELEMENTS;

    static {
        Set<String> skipped = new LinkedHashSet<String>();
        skipped.add("org.junit.runners.");
        skipped.add("org.springframework.boot.test.");
        skipped.add("cucumber.runtime.");
        SKIPPED_STACK_ELEMENTS = Collections.unmodifiableSet(skipped);
    }

    private SpringBootUtils(){}

    /**
     * 是否运行在spring jar in jar模式下
     */
    public static boolean isJarInJarMode(){
        Class<?> restartClassLoaderClass = null;
        try {
            restartClassLoaderClass = Class.forName("org.springframework.boot.devtools.restart.classloader.RestartClassLoader");
        } catch (ClassNotFoundException e) {
            //Ignore
        }

        //ClassLoader.getSystemClassLoader() 即 AppClassLoader
        if(SpringBootUtils.class.getClassLoader() != ClassLoader.getSystemClassLoader()
                && SpringBootUtils.class.getClassLoader().getClass() != restartClassLoaderClass) {
            return true;
        }
        return false;
    }

    /**
     * 判断当前是否正在运行单元测试
     * @return
     */
    public static boolean isUnitTestMode() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (isSkippedStackElement(element)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Checks if a specific {@link StackTraceElement} should cause the initializer to be
     * skipped.
     * @param element the stack element to check
     * @return {@code true} if the stack element means that the initializer should be
     * skipped
     */
    private static boolean isSkippedStackElement(StackTraceElement element) {
        for (String skipped : SKIPPED_STACK_ELEMENTS) {
            if (element.getClassName().startsWith(skipped)) {
                return true;
            }
        }
        return false;
    }
}
