package cn.com.duibaboot.ext.autoconfigure.data.hbase;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTableInterfaceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

/**
 * 初始化一个hbase的Connection供应用持续使用。(保持连接不断开)
 */
public class HTableConnectionFactory implements HTableInterfaceFactory {

    private static final Logger logger = LoggerFactory.getLogger(HTableConnectionFactory.class);

    private Connection connection;

    public HTableConnectionFactory(Configuration configuration){
        try {
            connection = ConnectionFactory.createConnection(configuration);
        } catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public HTableInterface createHTableInterface(Configuration config, byte[] tableName) {
        try {
            return (HTableInterface) connection.getTable(TableName.valueOf(tableName));
        } catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void releaseHTableInterface(HTableInterface table) throws IOException {
        //do nothing
    }

    public void destroy(){
        try {
            connection.close();
        } catch (IOException e) {
            logger.error("", e);
        }
    }
}
