package cn.com.duibaboot.ext.autoconfigure.devtools;

import com.google.common.collect.Sets;
import org.springframework.boot.devtools.classpath.ClassPathChangedEvent;
import org.springframework.boot.devtools.filewatch.ChangedFiles;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;

import java.util.Set;

public class ClassPathChangedFilesContainer {

    private ApplicationContext applicationContext;

    public ClassPathChangedFilesContainer(ApplicationContext applicationContext){
        this.applicationContext = applicationContext;
    }

    private Set<ChangedFiles> changedFilesSet = Sets.newHashSet();

    @EventListener
    public void onClassPathChanged(ClassPathChangedEvent event){
        if(!event.isRestartRequired()){
            //把class的变动缓存起来
            Set<ChangedFiles> set = event.getChangeSet();
            synchronized (changedFilesSet) {
                changedFilesSet.addAll(set);
            }
        }
    }

    public Set<ChangedFiles> getChangedFilesAndClear(){
        Set<ChangedFiles> set;
        synchronized (changedFilesSet){
            set = Sets.newHashSet(changedFilesSet);
            changedFilesSet.clear();
        }

        return set;
    }

    public void requestRestart(Set<?> changedFilesSet){
        applicationContext.publishEvent(new ClassPathChangedEvent(applicationContext, (Set<ChangedFiles>)changedFilesSet, true));
    }
}
