package cn.com.duibaboot.ext.autoconfigure.dubbo;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.registry.NotifyListener;
import com.alibaba.dubbo.registry.Registry;
import com.alibaba.dubbo.registry.RegistryFactory;

import java.util.List;

/**
 * 注册dubbo接口时添加参数，设置dubbo.registry.file路径,防止多个dubbo应用冲突报错：Can not lock the registry cache file。。。
 *
 * Created by wenqi.huang on 2016/12/5.
 */
public class DubboRegistryFactoryWrapper implements RegistryFactory {

    private RegistryFactory registryFactory;

    /**
     * 有这个方法的RegistryFactory才会被dubbo识别为wrapper
     * @return
     */
    public DubboRegistryFactoryWrapper(RegistryFactory registryFactory) {
        this.registryFactory = registryFactory;
    }

    public Registry getRegistry(URL url) {
        if(url.getParameter(Constants.FILE_KEY) == null) {
            //<dubbo:application/> 中设置的应用名
            String dubboApplicationName = url.getParameter("application");
            if(dubboApplicationName != null && !"".equals(dubboApplicationName.trim())) {
                url = url.addParameter(Constants.FILE_KEY, System.getProperty("user.home") + "/.dubbo/dubbo-registry-" + dubboApplicationName +".cache");//设置dubbo registry缓存文件的路径，防止启动多个dubbo应用的时候报错
            }
        }
        return this.registryFactory.getRegistry(url);
    }

}
