package cn.com.duibaboot.ext.autoconfigure.initserver;

import cn.com.duibaboot.ext.autoconfigure.core.AsyncSpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 2017/6/16.
 */
public class BeanPostProcessorOfSpecified implements BeanPostProcessor, Ordered {

    private List<SpecifiedBeanPostProcessor> processorList;
    private List<AsyncSpecifiedBeanPostProcessor> asyncProcessorList;
    private Map<AsyncSpecifiedBeanPostProcessor, Map<String, Object>> asyncProcessor2BeansMap;

    public BeanPostProcessorOfSpecified(List<SpecifiedBeanPostProcessor> processorList, List<AsyncSpecifiedBeanPostProcessor> asyncProcessorList, Map<AsyncSpecifiedBeanPostProcessor, Map<String, Object>>  asyncProcessor2BeansMap) {
        this.processorList = processorList;
        this.asyncProcessorList = asyncProcessorList;
        this.asyncProcessor2BeansMap = asyncProcessor2BeansMap;
    }

    @Override
    public int getOrder() {
        return -2;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        for(SpecifiedBeanPostProcessor p : processorList){
            if(p.getBeanType().isAssignableFrom(bean.getClass())){
                bean = p.postProcessBeforeInitialization(bean, beanName);
            }
        }
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        for(SpecifiedBeanPostProcessor p : processorList){
            if(p.getBeanType().isAssignableFrom(bean.getClass())){
                bean = p.postProcessAfterInitialization(bean, beanName);
            }
        }

        //生成需要被异步处理的map,方便后续被异步处理
        for(AsyncSpecifiedBeanPostProcessor asyncProcessor : asyncProcessorList){
            if(asyncProcessor.getBeanType().isAssignableFrom(bean.getClass())){
                Map<String, Object> beanMap = asyncProcessor2BeansMap.get(asyncProcessor);
                if(beanMap == null){
                    beanMap = new HashMap<>();
                    asyncProcessor2BeansMap.put(asyncProcessor, beanMap);
                }
                beanMap.put(beanName, bean);
            }
        }

        return bean;
    }

}
