package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duiba.boot.utils.RequestUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import org.springframework.http.HttpStatus;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Monitor拦截器, 提供/monitor/start,/monitor/stop,/monitor/check三个url
 */
public class BootMonitorCheckFilter implements Filter{

    //刚启动不提供服务，等待InitServerAutoConfiguration.SpringMvcInitConfiguration 调用过一次本服务后再开启服务。（这样做是因为首次web访问比较慢，需要先预热一下。）
    private static volatile boolean inService = false;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestPath = RequestUtils.getRequestPath(request);
        if(requestPath.equals("/monitor/check")){//检查服务器状态，OK表示正常，INVALID表示服务不可用
            if(!inService){
                response.setStatus(HttpStatus.SERVICE_UNAVAILABLE.value());
            }
            response.getWriter().write(inService ? "OK" : "INVALID");
        }else if(requestPath.equals("/monitor/stop")){//让check接口返回INVALID
            if(!HttpRequestUtils.isLocalRequest(request)){
                response.getWriter().write("NO PERMISSION");
                return;
            }
            inService = false;
            response.getWriter().write("OK");
        }else if(requestPath.equals("/monitor/start")){// 让check接口返回OK
            if(!HttpRequestUtils.isLocalRequest(request)){
                response.getWriter().write("NO PERMISSION");
                return;
            }
            inService = true;
            response.getWriter().write("OK");
        }else{
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    @Override
    public void destroy() {

    }

    /**
     * 设置服务状态。
     * @param inService
     */
    public static void setInService(boolean inService){
        BootMonitorCheckFilter.inService = inService;
    }

}
