package cn.com.duibaboot.ext.autoconfigure.web.mvc;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.DuibaFeignProperties;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.http.converter.HttpMessageConverter;

import java.util.Collection;
import java.util.List;

/**
 * 自定义的HttpMessageConverters，用于在HttpMessageConverter列表的最后附加fst/kryo的处理器，注意顺序很重要，一定要在json处理器后面，否则会出错
 */
public class CustomHttpMessageConverters extends HttpMessageConverters {

    public CustomHttpMessageConverters(HttpMessageConverter<?>... additionalConverters) {
        super(additionalConverters);
    }

    public CustomHttpMessageConverters(Collection<HttpMessageConverter<?>> additionalConverters) {
        super(additionalConverters);
    }

    public CustomHttpMessageConverters(boolean addDefaultConverters, Collection<HttpMessageConverter<?>> converters) {
        super(addDefaultConverters, converters);
    }

    @Override
    protected List<HttpMessageConverter<?>> postProcessConverters(List<HttpMessageConverter<?>> converters) {
        List<HttpMessageConverter<?>> list = super.postProcessConverters(converters);

        //给DuibaFeignSerialization中的每种序列化方式(hessian2/kryo/fst等)添加对应的HttpMessageConverter处理器。
        for(DuibaFeignProperties.DuibaFeignSerialization serialization : DuibaFeignProperties.DuibaFeignSerialization.values()){
            if(serialization != DuibaFeignProperties.DuibaFeignSerialization.JSON){
                list.add(new BaseBytesToObjectMessageConverter(serialization));
            }
        }
        return list;
    }
}
