package cn.com.duibaboot.ext.autoconfigure.xss;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

/**
 * 配置防止XSS攻击，原理是自动配置一个Filter，对于所有输入参数进行转义。request.getParameter/request.getHeader/request.getCookies 得到的结果均为经过转义的
 * Created by wenqi.huang on 2017/3/8.
 */
@Configuration
@ConditionalOnClass({ Servlet.class, DispatcherServlet.class,
        WebMvcConfigurerAdapter.class })
@ConditionalOnWebApplication
@ConditionalOnResource(resources = "/autoconfig_xss.properties")
public class XssAutoConfiguration {
    /**
     * 自动加入Http Filter，对于所有输入参数进行转义。request.getParameter/request.getHeader/request.getCookies 得到的结果均为经过转义的
     */
    @Bean
    public FilterRegistrationBean _xssFilterConfigurer(){
        XssFilter filter = new XssFilter();
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter(filter);
        List<String> urlPatterns=new ArrayList<String>();
        urlPatterns.add("/*");//拦截路径，可以添加多个
        registrationBean.setUrlPatterns(urlPatterns);
        registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
        registrationBean.setOrder(Ordered.HIGHEST_PRECEDENCE + 10);//在CharacterFilter后面
        return registrationBean;
    }
}
