package cn.com.duibaboot.ext.autoconfigure.data.hbase;

import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterfaceFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.hadoop.hbase.HbaseTemplate;

import javax.annotation.Resource;

/**
 * Hbase自动配置
 */
@Configuration
@ConditionalOnClass({HbaseTemplate.class, HTable.class})
@EnableConfigurationProperties(HbaseProperties.class)
public class HbaseAutoConfiguration {

    @Resource
    private HbaseProperties hbaseProperties;

    @Bean
    @ConditionalOnMissingBean(HTableInterfaceFactory.class)
    public HTableInterfaceFactory hTableInterfaceFactory(){
        org.apache.hadoop.conf.Configuration configuration = hbaseProperties.getConfiguration();

        return new HTableConnectionFactory(configuration);
    }

    @Bean
    @ConditionalOnMissingBean(HbaseTemplate.class)
    public HbaseTemplate hbaseTemplate(HTableInterfaceFactory hTableInterfaceFactory){
        org.apache.hadoop.conf.Configuration configuration = hbaseProperties.getConfiguration();

        HbaseTemplate hbaseTemplate = new WrappedHbaseTemplate(configuration);

        //使用自定义的工厂，以维持connection不断开；如果不设置这个，spring官方的HbaseTemplate在每次调用完毕后都会断开长连接.
        hbaseTemplate.setTableFactory(hTableInterfaceFactory);

        return hbaseTemplate;
    }

}
