package cn.com.duibaboot.ext.autoconfigure.logger.logback;

import ch.qos.logback.classic.pattern.ThreadConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import cn.com.duiba.boot.perftest.PerfTestContext;

/**
 * 在线程名后面附加Perf标记，表示当前线程在压测
 */
public class ThreadAndPerfTestConverter extends ThreadConverter {
    @Override
    public String convert(ILoggingEvent event) {
        if(!PerfTestContext.isCurrentInPerfTestMode()) {
            return super.convert(event);// + " [NoPerf]";
        }else{
            //在线程名后面附加Perf标记，表示当前线程在压测
            return super.convert(event) + " [Perf]";
        }
    }
}
