/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.boot.context.properties.ConfigurationProperties;
import shaded.com.esotericsoftware.kryo.Kryo;
import shaded.com.esotericsoftware.kryo.io.Input;
import shaded.com.esotericsoftware.kryo.io.Output;
import shaded.org.nustaq.serialization.FSTConfiguration;

@ConfigurationProperties(prefix="duiba.feign")
public class DuibaFeignProperties {
    private String serialization = "json";

    public String getSerialization() {
        return this.serialization;
    }

    public DuibaFeignSerialization getSerializationEnum() {
        return DuibaFeignSerialization.typeOf(this.serialization);
    }

    public void setSerialization(String serialization) {
        this.serialization = serialization;
    }

    public static enum DuibaFeignSerialization {
        FST("fst", "fst-bytes/fst"){

            @Override
            public byte[] serialize(Object obj) {
                if (obj == null) {
                    return null;
                }
                return fstConfiguration.asByteArray(obj);
            }

            @Override
            public <T> T deserialize(byte[] bs) {
                if (bs == null || bs.length == 0) {
                    return null;
                }
                return (T)fstConfiguration.asObject(bs);
            }
        }
        ,
        KRYO("kryo", "kryo-bytes/kryo"){

            @Override
            public byte[] serialize(Object obj) {
                if (obj == null) {
                    return null;
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Output output = new Output(out);
                kryo.writeClassAndObject(output, obj);
                output.close();
                return out.toByteArray();
            }

            @Override
            public <T> T deserialize(byte[] bs) {
                if (bs == null || bs.length == 0) {
                    return null;
                }
                ByteArrayInputStream in = new ByteArrayInputStream(bs);
                Input input = new Input(in);
                Object obj = kryo.readClassAndObject(input);
                input.close();
                return (T)obj;
            }
        }
        ,
        HESSIAN2("hessian2", "hessian2-bytes/hessian2"){

            @Override
            public byte[] serialize(Object obj) {
                if (obj == null) {
                    return null;
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Hessian2Output hessian2Output = new Hessian2Output((OutputStream)out);
                try {
                    hessian2Output.writeObject(obj);
                    hessian2Output.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return out.toByteArray();
            }

            @Override
            public <T> T deserialize(byte[] bs) {
                if (bs == null || bs.length == 0) {
                    return null;
                }
                ByteArrayInputStream in = new ByteArrayInputStream(bs);
                Hessian2Input hessian2Input = new Hessian2Input((InputStream)in);
                try {
                    return (T)hessian2Input.readObject();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ,
        JSON("json", "application/json"){

            @Override
            public byte[] serialize(Object obj) {
                throw new UnsupportedOperationException("not support json serialize, please serialize yourself");
            }

            public Object deserialize(byte[] bs) {
                throw new UnsupportedOperationException("not support json deserialize, please deserialize yourself");
            }
        };

        private String type;
        private String contentType;
        private static FSTConfiguration fstConfiguration;
        private static Kryo kryo;

        private DuibaFeignSerialization(String type, String contentType) {
            this.type = type;
            this.contentType = contentType;
        }

        public String getType() {
            return this.type;
        }

        public String getContentType() {
            return this.contentType;
        }

        public abstract byte[] serialize(Object var1);

        public abstract <T> T deserialize(byte[] var1);

        public static DuibaFeignSerialization typeOf(String type) {
            for (DuibaFeignSerialization s : DuibaFeignSerialization.values()) {
                if (!s.type.equals(type)) continue;
                return s;
            }
            throw new IllegalArgumentException("serialization type\uff1a" + type + " is illegal, must be one of: fst/kryo/json");
        }

        public static DuibaFeignSerialization contentTypeOf(String contentType) {
            for (DuibaFeignSerialization s : DuibaFeignSerialization.values()) {
                if (!s.contentType.equals(contentType)) continue;
                return s;
            }
            return null;
        }

        static {
            fstConfiguration = FSTConfiguration.createDefaultConfiguration();
            kryo = new Kryo();
        }
    }
}

