/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationNotAllowedException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.ResolvableType;

@Configuration
public class ApplicationEventMulticasterAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationEventMulticasterAutoConfiguration.class);

    @Bean(name={"applicationEventMulticaster"})
    public SimpleApplicationEventMulticaster simpleApplicationEventMulticaster() {
        CustomApplicationEventMulticaster multicaster = new CustomApplicationEventMulticaster();
        multicaster.setErrorHandler(t -> {
            if (t instanceof BeanCreationNotAllowedException && "eurekaAutoServiceRegistration".equals(((BeanCreationNotAllowedException)t).getBeanName()) && t.getMessage() != null && t.getMessage().contains("Singleton bean creation not allowed while singletons of this factory are in destruction")) {
                return;
            }
            logger.warn("Error calling ApplicationEventListener", t);
        });
        return multicaster;
    }

    public static class CustomApplicationEventMulticaster
    extends SimpleApplicationEventMulticaster {
        private BeanFactory beanFactory;
        private boolean started = false;

        public void setBeanFactory(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
            super.setBeanFactory(beanFactory);
        }

        public void multicastEvent(ApplicationEvent event) {
            super.multicastEvent(event);
        }

        public void multicastEvent(ApplicationEvent event, ResolvableType eventType) {
            if (event instanceof ContextRefreshedEvent && event.getSource() != null && event.getSource() instanceof AbstractApplicationContext) {
                if (((AbstractApplicationContext)event.getSource()).getBeanFactory() == this.beanFactory) {
                    this.started = true;
                } else if (!this.started) {
                    return;
                }
            }
            super.multicastEvent(event, eventType);
        }
    }
}

