/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.initserver;

import cn.com.duibaboot.ext.autoconfigure.core.AsyncSpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.initserver.ApplicationListenerForAsyncSpecified;
import cn.com.duibaboot.ext.autoconfigure.initserver.BeanPostProcessorOfSpecified;
import cn.com.duibaboot.ext.autoconfigure.web.BootMonitorCheckFilter;
import com.alibaba.dubbo.rpc.service.EchoService;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.hadoop.hbase.client.Result;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.dao.DataAccessException;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.data.hadoop.hbase.RowMapper;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import redis.clients.jedis.Jedis;

@Configuration
public class InitServerAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(InitServerAutoConfiguration.class);

    @Bean
    public BeanPostProcessorOfSpecified specifiedBeanPostProcessorConfigurer() {
        return new BeanPostProcessorOfSpecified();
    }

    @Bean
    public ApplicationListener<ContextRefreshedEvent> asyncSpecifiedBeanPostProcessorConfigurer() {
        BeanPostProcessorOfSpecified beanPostProcessorOfSpecified = this.specifiedBeanPostProcessorConfigurer();
        return new ApplicationListenerForAsyncSpecified(beanPostProcessorOfSpecified.getAsyncProcessor2BeansMap());
    }

    @Configuration
    @ConditionalOnClass(value={HbaseTemplate.class})
    public static class HbasePostProcessorConfiguration {
        @Bean
        public AsyncSpecifiedBeanPostProcessor hbasePostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<HbaseTemplate>(){

                @Override
                public Class<HbaseTemplate> getBeanType() {
                    return HbaseTemplate.class;
                }

                @Override
                public void postProcessAfterInitialization(HbaseTemplate hbaseTemplate, String beanName) {
                    try {
                        hbaseTemplate.get("hbase:meta", "1", (RowMapper)new RowMapper<String>(){

                            public String mapRow(Result result, int rowNum) throws Exception {
                                return null;
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={MongoOperations.class})
    public static class MongoDbPostProcessorConfiguration {
        @Bean
        public AsyncSpecifiedBeanPostProcessor mongoDbPostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<MongoOperations>(){

                @Override
                public Class<MongoOperations> getBeanType() {
                    return MongoOperations.class;
                }

                @Override
                public void postProcessAfterInitialization(MongoOperations mongoOperations, String beanName) {
                    try {
                        mongoOperations.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)"1")), String.class, "test_collection");
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={ElasticsearchOperations.class})
    public static class ElasticSearchPostProcessorConfiguration {
        @Bean
        public AsyncSpecifiedBeanPostProcessor elasticSearchPostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<ElasticsearchOperations>(){

                @Override
                public Class<ElasticsearchOperations> getBeanType() {
                    return ElasticsearchOperations.class;
                }

                @Override
                public void postProcessAfterInitialization(ElasticsearchOperations elasticsearchOperations, String beanName) {
                    elasticsearchOperations.indexExists("justForTest");
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={RedisTemplate.class})
    public static class RedisPostProcessorConfiguration {
        @Bean
        public AsyncSpecifiedBeanPostProcessor redisPostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<RedisTemplate>(){

                @Override
                public Class<RedisTemplate> getBeanType() {
                    return RedisTemplate.class;
                }

                @Override
                public void postProcessAfterInitialization(RedisTemplate redisTemplate, String beanName) {
                    redisTemplate.execute(new RedisCallback(){

                        public Object doInRedis(RedisConnection connection) throws DataAccessException {
                            Jedis jedis = (Jedis)connection.getNativeConnection();
                            return jedis.get("justForInitTest");
                        }
                    });
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={CannotGetJdbcConnectionException.class, BasicDataSource.class})
    public static class DataSourcePostProcessorConfiguration {
        @Bean
        public AsyncSpecifiedBeanPostProcessor dataSourcePostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<DataSource>(){

                @Override
                public Class<DataSource> getBeanType() {
                    return DataSource.class;
                }

                @Override
                public void postProcessAfterInitialization(DataSource dataSource, String beanName) {
                    Connection conn = null;
                    try {
                        conn = dataSource.getConnection();
                    }
                    catch (SQLException e) {
                        throw new CannotGetJdbcConnectionException("Could not get JDBC Connection", e);
                    }
                    finally {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={EchoService.class})
    public static class DubboPostProcessorConfiguration {
        @Bean
        public AsyncSpecifiedBeanPostProcessor dubboPostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<EchoService>(){

                @Override
                public Class<EchoService> getBeanType() {
                    return EchoService.class;
                }

                @Override
                public void postProcessAfterInitialization(EchoService echoService, String beanName) {
                    try {
                        echoService.$echo((Object)"OK");
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            };
        }
    }

    @Configuration
    public static class SpringMvcInitConfiguration
    implements ApplicationListener<EmbeddedServletContainerInitializedEvent> {
        public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
            int port = event.getEmbeddedServletContainer().getPort();
            try (CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(200).setSocketTimeout(5000).setConnectionRequestTimeout(100).build()).setMaxConnPerRoute(1).setMaxConnTotal(1).setUserAgent("DuibaBootInit").disableAutomaticRetries().disableCookieManagement().build();){
                HttpGet monitorCheckReq = new HttpGet("http://localhost:" + port + "/monitor/check");
                CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)monitorCheckReq);
                resp.close();
            }
            catch (IOException e) {
                logger.warn("init self failed", (Throwable)e);
            }
            BootMonitorCheckFilter.setInService(true);
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={ServletRegistrationBean.class})
    public static class SpringServletInitConfiguration {
        @Bean
        public SpecifiedBeanPostProcessor webPostProcessorConfigurer() {
            return new SpecifiedBeanPostProcessor<ServletRegistrationBean>(){

                public int getOrder() {
                    return 0;
                }

                @Override
                public Class<ServletRegistrationBean> getBeanType() {
                    return ServletRegistrationBean.class;
                }

                @Override
                public Object postProcessBeforeInitialization(ServletRegistrationBean bean, String beanName) throws BeansException {
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(ServletRegistrationBean bean, String beanName) throws BeansException {
                    if (bean.getServletName().equalsIgnoreCase("dispatcherServlet")) {
                        bean.setLoadOnStartup(1);
                    }
                    return bean;
                }
            };
        }
    }
}

