/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.graceclose;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.devtools.classpath.ClassPathChangedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

@Configuration
public class GracefulCloseAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(GracefulCloseAutoConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;

    @EventListener
    public void onClassPathChanged(ContextRefreshedEvent event) {
        GracefulCloseLifeCycle.isDevToolRestarting = false;
    }

    @Bean
    public GracefulCloseLifeCycle gracefulCloseLifeCycle() {
        int sleepSeconds = 6;
        String isInUnitTest = this.applicationContext.getEnvironment().getProperty("org.springframework.boot.test.context.SpringBootTestContextBootstrapper");
        if ("true".equals(isInUnitTest)) {
            sleepSeconds = 0;
        }
        return new GracefulCloseLifeCycle(sleepSeconds);
    }

    public static class GracefulCloseLifeCycle
    implements SmartLifecycle {
        private volatile boolean isRunning = false;
        private final int sleepSeconds;
        protected static volatile boolean isDevToolRestarting = false;

        public GracefulCloseLifeCycle(int sleepSeconds) {
            this.sleepSeconds = sleepSeconds;
        }

        public boolean isAutoStartup() {
            return true;
        }

        public void stop(final Runnable callback) {
            this.isRunning = false;
            new Thread(){

                @Override
                public void run() {
                    try {
                        if (!logger.isInfoEnabled()) {
                            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                            loggerContext.getLogger(GracefulCloseAutoConfiguration.class).setLevel(Level.INFO);
                        }
                        if (isDevToolRestarting) {
                            logger.info("detect devtools is restarting, close immediately");
                            return;
                        }
                        logger.info("sleep {} seconds to wait nginx/ribbon check", (Object)sleepSeconds);
                        TimeUnit.SECONDS.sleep(sleepSeconds);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        callback.run();
                    }
                }
            }.start();
        }

        public void start() {
            this.isRunning = true;
        }

        public void stop() {
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public int getPhase() {
            return -1;
        }
    }

    @Configuration
    @ConditionalOnClass(value={ClassPathChangedEvent.class})
    static class GracefulCloseDevToolsConfiguration {
        GracefulCloseDevToolsConfiguration() {
        }

        @EventListener
        @Order(value=-2147483648)
        public void onClassPathChanged(ClassPathChangedEvent event) {
            if (event.isRestartRequired()) {
                GracefulCloseLifeCycle.isDevToolRestarting = true;
            }
        }
    }
}

