/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duiba.wolf.threadpool.MonitorCallable;
import cn.com.duiba.wolf.threadpool.MonitorRunnable;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.core.DuibaServerProperties;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.threads.TaskQueue;
import org.apache.tomcat.util.threads.TaskThreadFactory;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.util.ReflectionUtils;

public class ThreadPoolServletContainerCustomizer
implements EmbeddedServletContainerCustomizer {
    public static final String HTTP_FAIL_FAST_THREAD_NAME_PREFIX = "HttpFailFastThread";
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolServletContainerCustomizer.class);
    private static volatile DuibaServerProperties duibaServerProperties;

    public ThreadPoolServletContainerCustomizer(DuibaServerProperties duibaServerProperties) {
        ThreadPoolServletContainerCustomizer.duibaServerProperties = duibaServerProperties;
    }

    public void customize(ConfigurableEmbeddedServletContainer container) {
        if (container instanceof TomcatEmbeddedServletContainerFactory) {
            TomcatEmbeddedServletContainerFactory factory = (TomcatEmbeddedServletContainerFactory)container;
            factory.setProtocol(DuibaHttp11NioProtocol.class.getName());
        }
    }

    private static class TomcatMonitorThreadPoolExecutor
    extends ThreadPoolExecutor {
        public TomcatMonitorThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
        }

        public TomcatMonitorThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        }

        public TomcatMonitorThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        public TomcatMonitorThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        public void execute(Runnable command) {
            super.execute((Runnable)new MonitorRunnable(command, this.getQueue()));
        }

        public <T> Future<T> submit(Callable<T> task) {
            return super.submit((Callable)new MonitorCallable(task, this.getQueue()));
        }

        public <T> Future<T> submit(Runnable task, T result) {
            return super.submit((Runnable)new MonitorRunnable(task, this.getQueue()), result);
        }

        public Future<?> submit(Runnable task) {
            return super.submit((Runnable)new MonitorRunnable(task, this.getQueue()));
        }
    }

    public static class DuibaHttp11NioProtocol
    extends Http11NioProtocol {
        private ThreadPoolExecutor http11NioExecutor;
        private java.util.concurrent.ThreadPoolExecutor httpFailFastExecutor;
        private ScheduledExecutorService scheduledExecutorService;
        private long executorTerminationTimeoutMillis;
        private String endpointName;

        public AbstractEndpoint getEndpointInner() throws InvocationTargetException, IllegalAccessException {
            try {
                return super.getEndpoint();
            }
            catch (Throwable e) {
                Class<Http11NioProtocol> clazz = Http11NioProtocol.class;
                Method endpointMethod = ReflectionUtils.findMethod(clazz, (String)"getEndpoint");
                endpointMethod.setAccessible(true);
                AbstractEndpoint endpoint = (AbstractEndpoint)endpointMethod.invoke((Object)this, null);
                return endpoint;
            }
        }

        private void createExecutor() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            AbstractEndpoint endpoint = this.getEndpointInner();
            this.executorTerminationTimeoutMillis = endpoint.getExecutorTerminationTimeoutMillis();
            this.endpointName = endpoint.getName();
            if (this.http11NioExecutor == null) {
                TaskThreadFactory tf = new TaskThreadFactory(this.endpointName + "-exec-", true, this.getThreadPriority());
                int minThreads = this.getMinSpareThreads();
                long timeToLive = 60L;
                if (duibaServerProperties.isInternalMode()) {
                    minThreads = this.getMaxThreads();
                    timeToLive = 0L;
                }
                TaskQueue taskqueue = new TaskQueue();
                TomcatMonitorThreadPoolExecutor executor = new TomcatMonitorThreadPoolExecutor(minThreads, this.getMaxThreads(), timeToLive, TimeUnit.SECONDS, (BlockingQueue<Runnable>)taskqueue, (ThreadFactory)tf);
                taskqueue.setParent((ThreadPoolExecutor)executor);
                this.http11NioExecutor = executor;
            }
        }

        public void start() throws Exception {
            try {
                if (duibaServerProperties.isInternalMode()) {
                    this.getEndpointInner().setMaxKeepAliveRequests(Integer.MAX_VALUE);
                }
                this.createExecutor();
                this.setExecutor((Executor)this.http11NioExecutor);
                if (duibaServerProperties.isInternalMode()) {
                    this.startFailFastService();
                }
            }
            catch (Exception e) {
                logger.warn("getEndpoint \u5931\u8d25\uff0c\u4e0d\u4f1a\u7ed9tomcat\u6ce8\u5165\u7ebf\u7a0b\u6c60\u76d1\u63a7\u529f\u80fd", (Throwable)e);
            }
            super.start();
        }

        public void stop() throws Exception {
            super.stop();
            if (this.http11NioExecutor != null && this.http11NioExecutor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = this.http11NioExecutor;
                tpe.shutdownNow();
                if (this.executorTerminationTimeoutMillis > 0L) {
                    try {
                        tpe.awaitTermination(this.executorTerminationTimeoutMillis, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (tpe.isTerminating()) {
                        this.getLog().warn((Object)sm.getString("endpoint.warn.executorShutdown", new Object[]{this.endpointName}));
                    }
                }
                TaskQueue queue = (TaskQueue)tpe.getQueue();
                queue.setParent(null);
            }
            if (duibaServerProperties.isInternalMode()) {
                this.stopFailFastService();
            }
        }

        private void stopFailFastService() {
            if (this.scheduledExecutorService != null) {
                this.scheduledExecutorService.shutdownNow();
            }
            if (this.httpFailFastExecutor != null) {
                this.httpFailFastExecutor.shutdownNow();
            }
        }

        private void startFailFastService() {
            this.httpFailFastExecutor = new java.util.concurrent.ThreadPoolExecutor(1, 3, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100), (ThreadFactory)new NamedThreadFactory(ThreadPoolServletContainerCustomizer.HTTP_FAIL_FAST_THREAD_NAME_PREFIX));
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("HttpFailFastScheduledThread"));
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    Runnable runnable;
                    if (http11NioExecutor.getSubmittedCount() < http11NioExecutor.getMaximumPoolSize()) {
                        return;
                    }
                    BlockingQueue tomcatWorkQueue = http11NioExecutor.getQueue();
                    if (tomcatWorkQueue.isEmpty()) {
                        return;
                    }
                    while (!tomcatWorkQueue.isEmpty() && (runnable = (Runnable)tomcatWorkQueue.peek()) != null) {
                        boolean needMoveIntoAnotherPool = false;
                        if (runnable instanceof MonitorRunnable) {
                            MonitorRunnable mr = (MonitorRunnable)runnable;
                            long createTimeMillis = mr.getSubmitTimeMillis();
                            if (System.currentTimeMillis() - createTimeMillis > 50L) {
                                needMoveIntoAnotherPool = true;
                            }
                        } else {
                            logger.warn("[NOTIFYME]will never happens here");
                        }
                        if (!needMoveIntoAnotherPool) break;
                        boolean removed = tomcatWorkQueue.remove(runnable);
                        if (!removed) continue;
                        try {
                            httpFailFastExecutor.execute(runnable);
                        }
                        catch (RejectedExecutionException e) {
                            logger.warn("[NOTIFYME]put http thread into HttpFailFastThread failed,this will never happen", (Throwable)e);
                        }
                    }
                }
            }, 1000L, 10L, TimeUnit.MILLISECONDS);
        }
    }
}

