/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web.mvc;

import cn.com.duiba.boot.exception.BizException;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Order(value=0x7FFFFFF5)
public class BizExceptionResolver
implements HandlerExceptionResolver,
Ordered {
    @Autowired
    private ErrorAttributes errorAttributes;

    public int getOrder() {
        return 0x7FFFFFF5;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (ex instanceof BizException) {
            Map<String, Object> body = this.getErrorAttributes(request, false);
            body.put("status", HttpStatus.INTERNAL_SERVER_ERROR.value());
            body.put("error", HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
            if (((BizException)ex).getCode() != null) {
                body.put("code", ((BizException)ex).getCode());
            }
            String jsonStr = JSON.toJSONString(body);
            try {
                response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
                IOUtils.write((String)jsonStr, (OutputStream)response.getOutputStream(), (Charset)Charsets.UTF_8);
                IOUtils.closeQuietly((OutputStream)response.getOutputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return new ModelAndView();
        }
        return null;
    }

    private Map<String, Object> getErrorAttributes(HttpServletRequest request, boolean includeStackTrace) {
        ServletRequestAttributes requestAttributes = new ServletRequestAttributes(request);
        return this.errorAttributes.getErrorAttributes((RequestAttributes)requestAttributes, includeStackTrace);
    }
}

