package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duibaboot.ext.autoconfigure.graceclose.GracefulCloseRunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

/**
 * 给cat初始化一些环境变量（当前应用名）
 */
public class CatEnvPreparer implements SpringApplicationRunListener {

    private static final Logger logger = LoggerFactory.getLogger(GracefulCloseRunListener.class);

    private SpringApplication application;

    /**
     * 必须有这个构造函数，否则spring无法初始化该类
     * @param application
     * @param args
     */
    public CatEnvPreparer(SpringApplication application, String[] args) {
        this.application = application;
    }

    //@Override //boot新版本没有这个方法，故去掉Override
    public void started() {
    }

    // boot 1.5.2 新版本有这个方法，故要实现
    public void starting() {
    }

    //@Override
    public void environmentPrepared(ConfigurableEnvironment environment) {
        //初始化cat监控
        String appName = environment.getProperty("spring.application.name");
        if(StringUtils.isEmpty(appName)){
            logger.warn("you need to set property[spring.application.name] in bootstrap.properties");
            return;
        }
        System.setProperty("cat.app.name", appName);//注入appName,以方便后续cat获取
    }

    //@Override
    public void contextPrepared(ConfigurableApplicationContext context) {

    }

    //@Override
    public void contextLoaded(ConfigurableApplicationContext context) {

    }

    @Override
    public void finished(final ConfigurableApplicationContext context, Throwable exception) {
    }

}
