package cn.com.duibaboot.ext.autoconfigure.core;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;

/**
 * 用于发送MainContextRefreshedEvent事件
 */
public class MainContextRefreshedEventPublishLifeCycle extends EarlyClose implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    @Override
    public void start() {
        super.start();

        applicationContext.publishEvent(new MainContextRefreshedEvent(applicationContext));
    }

    @Override
    public void stop() {
        //do nothing
    }

    @Override
    public int getPhase() {
        return Ordered.LOWEST_PRECEDENCE;//优先级最低，以让其他LifeCycle都start完成后再start本lifeCycle
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
