package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.perftest.PerfTestContext;
import com.aliyun.openservices.ons.api.Message;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 加入AOP，压测时ons消息添加压测标识
 */
@Aspect
public class OnsPerfAspect {


    private static final Logger logger = LoggerFactory.getLogger(OnsPerfAspect.class);


    @Around("execution(* com.aliyun.openservices.ons.api.Producer+.*(..))")
    public Object onsSendJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            PerfTestContext.debugInfo("onsProducer");
            Object[] args = joinPoint.getArgs();
            if (methodName.startsWith("send")) {
                if (args[0] instanceof Message) {
                    Message rawMsg = (Message) args[0];
                    rawMsg.putUserProperties("perfTest", "true");
                    return joinPoint.proceed(args);
                }
            }
        }
        return joinPoint.proceed();
    }

    @Around("execution(* com.aliyun.openservices.ons.api.MessageListener+.*(..))")
    public Object onsConsumeJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (methodName.equals("consume")) {
            Object[] args = joinPoint.getArgs();
            if (args[0] instanceof Message) {
                Message rawMsg = (Message) args[0];
                if (rawMsg.getUserProperties("perfTest") != null) {
                    PerfTestContext._setPerfTestMode(true);
                    PerfTestContext.debugInfo("onsConsumer");
                    Object result= joinPoint.proceed();
                    PerfTestContext._setPerfTestMode(false);
                    return result;
                }
            }
        }
        return joinPoint.proceed();
    }
}
