package cn.com.duibaboot.ext.autoconfigure.web.mvc;

import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

import java.util.ArrayList;
import java.util.List;

/**
 * 把AdvancedFeignClientArgumentResolver放到参数解析器的第一个位置。
 */
public class CustomRequestMappingHandlerAdapter extends RequestMappingHandlerAdapter {
    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();

        List<HandlerMethodArgumentResolver> arList = new ArrayList<>(super.getArgumentResolvers());

        //确保AdvancedFeignClient的参数解析器在第一个位置
        arList.add(0, new AdvancedFeignClientArgumentResolver());

        super.setArgumentResolvers(arList);
    }
}
