package cn.com.duibaboot.ext.autoconfigure.core;

import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;

/**
 * 用于检测当前工程引入的spring-boot版本号
 * Created by wenqi.huang on 2017/5/23.
 */
public class SpringBootVersion {

    private static final String MF = "META-INF/MANIFEST.MF";
    private static final String VERSION_PREFIX = "Implementation-Version: ";

    private static volatile String currentVersion;

    /**
     * 获得当前的sprig-boot版本号，比如：1.3.8-RELEASE, 1.4.5-RELEASE
     * @return
     * @throws IOException
     */
    public static String getCurrentVersion() {
        if(currentVersion == null) {
            try {
                ClassLoader classLoader = SpringBootVersion.class.getClassLoader();
                Enumeration<URL> urls;
                if (classLoader != null) {
                    urls = classLoader.getResources(MF);
                } else {
                    urls = ClassLoader.getSystemResources(MF);
                }
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    BufferedInputStream in = new BufferedInputStream(url.openStream());
                    LineIterator iter = IOUtils.lineIterator(in, Charset.forName("ISO-8859-1"));
                    String version = null;
                    boolean isMatch = false;
                    while (iter.hasNext()) {
                        String line = iter.next();
                        if (line == null) {
                            continue;
                        }
                        if (line.equals("Implementation-Title: Spring Boot")) {//找到了spring-boot的MANIFEST.MF文件
                            isMatch = true;
                        } else if (line.startsWith(VERSION_PREFIX)) {
                            version = line.substring(VERSION_PREFIX.length());
                        }
                        if (isMatch && version != null) {
                            break;
                        }
                    }
                    if (isMatch && version != null) {
                        currentVersion = version;
                        break;
                    }
                }
            }catch(IOException e){
                throw new IllegalStateException(e);
            }
        }
        return currentVersion;
    }

}
