package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.perftest.PerfTestContext;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.*;

/**
 * dubbo压测Filter，用于设置压测标记.
 * Created by wenqi.huang on 2016/11/24.
 */
@Activate(group={"consumer","provider"},order = 0)
public class DubboPerfTestFilter implements Filter {

    public static final String IS_PERF_TEST_MODE = "isPerfTestMode";

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        URL url = invoker.getUrl();
        String sideKey = url.getParameter("side");
        boolean isConsumerSide = "consumer".equals(sideKey);
        boolean isProviderSide = "provider".equals(sideKey);

        RpcContext context = RpcContext.getContext();
        //不能使用context.isConsumerSide()/context.isProviderSide()，在嵌套dubbo调用的时候会改变。。坑
        if(isConsumerSide) {
            if (PerfTestContext.isCurrentInPerfTestMode()) {//表示线上压测流量
                boolean isPerfTestSupportted = invoker.getUrl().getParameter(DubboPerfTestRegistryFactoryWrapper.IS_PERF_TEST_SUPPORTTED_KEY, false);
                if(!isPerfTestSupportted){
                    throw new RpcException("dubbo invoker:"+invoker.getUrl().toServiceString()+"，识别到当前请求是压测流量，但是对应的服务不支持性能压测，放弃本次请求，请通知该服务负责人加入spring-boot-starter-perftest依赖");
                }
                context.setAttachment(IS_PERF_TEST_MODE, "true");//这个标记在dubbo请求完毕后会自动清空
            }
        }else{
            String val = context.getAttachment(IS_PERF_TEST_MODE);
            if("true".equals(val)){
                PerfTestContext._setPerfTestMode(true);
            }
        }

        Result result;
        try {
            result = invoker.invoke(invocation);
        }finally {
            if(isProviderSide) {
                PerfTestContext._setPerfTestMode(false);
            }
        }
        return result;
    }
}
