/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.hystrix;

import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixCommand;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.hystrix.FeignErrorDecoder;
import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixThreadPoolKey;
import feign.Feign;
import feign.RetryableException;
import feign.Retryer;
import feign.Target;
import feign.codec.ErrorDecoder;
import feign.hystrix.HystrixFeign;
import feign.hystrix.SetterFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@ConditionalOnClass(value={HystrixCommand.class, HystrixFeign.class})
public class HystrixFeignConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(HystrixFeignConfiguration.class);
    private static final Set<String> hystrixThreadPoolKeyNames = Sets.newHashSet((Object[])new String[]{"maxQueueSize", "coreSize", "maximumSize", "allowMaximumSizeToDivergeFromCoreSize", "keepAliveTimeMinutes", "queueSizeRejectionThreshold", "metrics.rollingStats.numBuckets", "metrics.rollingStats.timeInMilliseconds"});

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"feign.hystrix.enabled"}, matchIfMissing=true)
    public Feign.Builder feignHystrixBuilder() {
        return HystrixFeign.builder().setterFactory((SetterFactory)new HystrixFeignSetterFactory());
    }

    @Bean
    public ErrorDecoder feignErrorDecoder() {
        return new FeignErrorDecoder();
    }

    final class HystrixFeignSetterFactory
    implements SetterFactory {
        HystrixFeignSetterFactory() {
        }

        public HystrixCommand.Setter create(Target<?> target, Method method) {
            String defaultGroupKey = target.name();
            String defaultCommandKey = Feign.configKey((Class)target.type(), (Method)method);
            FeignHystrixCommand methodCommand = method.getAnnotation(FeignHystrixCommand.class);
            Object[] methodProperties = (FeignHystrixProperty[])method.getAnnotationsByType(FeignHystrixProperty.class);
            FeignHystrixCommand classCommand = target.type().getAnnotation(FeignHystrixCommand.class);
            Object[] classProperties = (FeignHystrixProperty[])target.type().getAnnotationsByType(FeignHystrixProperty.class);
            ArrayList<FeignHystrixCommand> commands = new ArrayList<FeignHystrixCommand>();
            commands.add(methodCommand);
            commands.add(classCommand);
            String groupKey = commands.stream().filter(c -> c != null && StringUtils.isNotBlank((String)c.groupKey())).findFirst().map(c -> c.groupKey()).orElse(defaultGroupKey);
            String commandKey = methodCommand == null || StringUtils.isBlank((String)methodCommand.commandKey()) ? defaultCommandKey : methodCommand.commandKey();
            String threadPoolKey = commands.stream().filter(c -> c != null && StringUtils.isNotBlank((String)c.threadPoolKey())).findFirst().map(c -> c.threadPoolKey()).orElse(null);
            HystrixCommand.Setter setter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)groupKey));
            setter.andCommandKey(HystrixCommandKey.Factory.asKey((String)commandKey));
            if (threadPoolKey != null) {
                setter.andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)threadPoolKey));
            }
            ArrayList<FeignHystrixProperty> allProperties = new ArrayList<FeignHystrixProperty>();
            List<Object> packageProperties = new ArrayList<FeignHystrixProperty>();
            this.injectPropertiesFromPackages(target.type().getPackage().getName(), packageProperties);
            packageProperties = Lists.reverse(packageProperties);
            allProperties.addAll(packageProperties);
            ArrayList<FeignHystrixProperty> classAndMethodProperties = new ArrayList<FeignHystrixProperty>();
            if (classCommand != null && !ArrayUtils.isEmpty((Object[])classCommand.properties())) {
                for (FeignHystrixProperty feignHystrixProperty : classCommand.properties()) {
                    classAndMethodProperties.add(feignHystrixProperty);
                }
            }
            if (!ArrayUtils.isEmpty((Object[])classProperties)) {
                for (Object object : classProperties) {
                    classAndMethodProperties.add((FeignHystrixProperty)object);
                }
            }
            if (methodCommand != null && !ArrayUtils.isEmpty((Object[])methodCommand.properties())) {
                for (FeignHystrixProperty feignHystrixProperty : methodCommand.properties()) {
                    classAndMethodProperties.add(feignHystrixProperty);
                }
            }
            if (!ArrayUtils.isEmpty((Object[])methodProperties)) {
                for (Object object : methodProperties) {
                    classAndMethodProperties.add((FeignHystrixProperty)object);
                }
            }
            if (threadPoolKey == null && StringUtils.equals((String)defaultGroupKey, (String)groupKey) || threadPoolKey != null && StringUtils.equals((String)threadPoolKey, (String)defaultGroupKey)) {
                this.validateHystrixThreadPoolKeyPropertiesNotExists(classAndMethodProperties, target.type(), method);
            }
            allProperties.addAll(classAndMethodProperties);
            setter.andCommandPropertiesDefaults(HystrixPropertiesManager.initializeCommandProperties(allProperties));
            setter.andThreadPoolPropertiesDefaults(HystrixPropertiesManager.initializeThreadPoolProperties(allProperties));
            return setter;
        }

        private void validateHystrixThreadPoolKeyPropertiesNotExists(List<FeignHystrixProperty> classAndMethodProperties, Class<?> clazz, Method method) {
            for (FeignHystrixProperty p : classAndMethodProperties) {
                if (!hystrixThreadPoolKeyNames.contains(p.name())) continue;
                throw new IllegalStateException(String.format("\u5982\u679c\u65b9\u6cd5\u6216\u7c7b\u4e0a\u6ca1\u6709\u6307\u5b9a\u975e\u9ed8\u8ba4\u7684groupKey/threadPoolKey\uff08\u53ef\u4ee5\u4f7f\u7528@FeignHystrixCommand\u6ce8\u89e3\u6307\u5b9a\uff09\uff0c\u5219\u4f60\u4e0d\u80fd\u6307\u5b9aHystrix\u7ebf\u7a0b\u6c60\u76f8\u5173\u7684\u914d\u7f6e\uff0c\u4f46\u662f\u4f60\u6307\u5b9a\u4e86`%s`, \u8bf7\u68c0\u67e5\u7c7b:`%s`, \u65b9\u6cd5: `%s` (\u8b66\u544a\uff1a\u5bf9\u4e8eHystrix\u7ebf\u7a0b\u6c60\u914d\u7f6e\uff0chystrix\u4f1a\u59cb\u7ec8\u4f7f\u7528\u9996\u6b21\u52a0\u8f7d\u7684\u914d\u7f6e\uff0c\u5982\u679c\u4f60\u5728\u591a\u4e2a\u7c7b\u6216\u591a\u4e2a\u65b9\u6cd5\u4e0a\u5bf9\u4e8e\u540c\u4e00\u4e2athreadPoolKey\u6307\u5b9a\u4e86\u4e0d\u540c\u7684\u7ebf\u7a0b\u6c60\u914d\u7f6e\uff0c\u5219\u54ea\u4e2a\u914d\u7f6e\u751f\u6548\u662f\u4e0d\u786e\u5b9a\u7684.)", p.name(), clazz.getName(), method.getName()));
            }
        }

        private void injectPropertiesFromPackages(String packageName, List<FeignHystrixProperty> packageProperties) {
            if (packageName == null) {
                return;
            }
            try {
                Class.forName(packageName + ".package-info");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Package pkg = Package.getPackage(packageName);
            if (pkg == null) {
                this.injectPropertiesFromPackages(this.parentPackage(packageName), packageProperties);
                return;
            }
            Object[] properties = (FeignHystrixProperty[])pkg.getAnnotationsByType(FeignHystrixProperty.class);
            if (!ArrayUtils.isEmpty((Object[])properties)) {
                int packageLevel = org.apache.commons.lang3.StringUtils.split((String)packageName, (String)".").length;
                if (packageLevel < 3) {
                    throw new IllegalStateException(String.format("@FeignHystrixProperty must be annotated on a package have at least %d levels, current package is : %s, level is: %d", 3, packageName, packageLevel));
                }
                packageProperties.addAll(Arrays.asList(properties));
            }
            this.injectPropertiesFromPackages(this.parentPackage(packageName), packageProperties);
        }

        private String parentPackage(String packageName) {
            int idx = packageName.lastIndexOf(".");
            if (idx == -1) {
                return null;
            }
            return packageName.substring(0, idx);
        }
    }

    @Configuration
    public static class CustomRetryer
    implements Retryer {
        private int maxAttempts = 2;
        private int attempt = 1;

        public void continueOrPropagate(RetryableException e) {
            if (this.attempt == 1 && RpcContext.hasContext()) {
                RpcContext rc = RpcContext.getContext();
                Field msgField = FieldUtils.getDeclaredField(Throwable.class, (String)"detailMessage", (boolean)true);
                try {
                    FieldUtils.writeField((Field)msgField, (Object)e, (Object)(e.getMessage() + " (" + rc.getLocalAddr() + " -> " + rc.getRemoteAddr() + ")"));
                }
                catch (IllegalAccessException e1) {
                    throw new RuntimeException("[NOTIFYME] will never be here", e1);
                }
            }
            if (this.attempt++ >= this.maxAttempts) {
                throw e;
            }
            Throwable cause = e.getCause();
            if (cause == null) {
                throw e;
            }
            if (cause instanceof RejectedExecutionException) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            } else if (cause instanceof SocketTimeoutException && "connect timed out".equals(cause.getMessage())) {
                logger.warn("connect timed out, retry again. reqId:{}", (Object)"undefined");
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            } else {
                throw e;
            }
        }

        public Retryer clone() {
            return new CustomRetryer();
        }
    }
}

