/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="duiba.rocketmq")
public class RocketMqProperties {
    private ProducerProperties producer;
    private ConsumerProperties consumer;
    private ConsumerProperties[] extraConsumer;
    private String nameSrvAddr;

    public ProducerProperties getProducer() {
        return this.producer;
    }

    public void setProducer(ProducerProperties producer) {
        this.producer = producer;
    }

    public ConsumerProperties getConsumer() {
        return this.consumer;
    }

    public void setConsumer(ConsumerProperties consumer) {
        this.consumer = consumer;
    }

    public String getNameSrvAddr() {
        if (this.nameSrvAddr != null && this.nameSrvAddr.trim().equals("")) {
            return null;
        }
        return this.nameSrvAddr;
    }

    public void setNameSrvAddr(String nameSrvAddr) {
        this.nameSrvAddr = nameSrvAddr;
    }

    public ConsumerProperties[] getExtraConsumer() {
        return this.extraConsumer;
    }

    public void setExtraConsumer(ConsumerProperties[] extraConsumer) {
        this.extraConsumer = extraConsumer;
    }

    public static class ConsumerProperties {
        private Boolean enable = false;
        private String group;
        private String topics;
        private String messageModel = MessageModel.CLUSTERING.getModeCN();
        private Integer maxReconsumeTimes = 16;
        private Integer consumeThreadNums = 0;

        public Boolean getEnable() {
            return this.enable;
        }

        public void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public Integer getMaxReconsumeTimes() {
            return this.maxReconsumeTimes;
        }

        public void setMaxReconsumeTimes(Integer maxReconsumeTimes) {
            this.maxReconsumeTimes = maxReconsumeTimes;
        }

        public Integer getConsumeThreadNums() {
            return this.consumeThreadNums;
        }

        public void setConsumeThreadNums(Integer consumeThreadNums) {
            this.consumeThreadNums = consumeThreadNums;
        }

        public String getTopics() {
            return this.topics;
        }

        public void setTopics(String topics) {
            this.topics = topics;
        }

        public String getMessageModel() {
            return this.messageModel;
        }

        public MessageModel getMessageModelEnum() {
            for (MessageModel m : MessageModel.values()) {
                if (!m.getModeCN().equals(this.messageModel)) continue;
                return m;
            }
            throw new IllegalStateException("illegal messageModel of rocketmq, must be one of [CLUSTERING, BROADCASTING], but you set: " + this.messageModel);
        }

        public void setMessageModel(String messageModel) {
            this.messageModel = messageModel;
        }
    }

    public static class ProducerProperties {
        private Boolean enable = false;
        private String group;
        private Integer sendMsgTimeoutMillis = 400;

        public Boolean getEnable() {
            return this.enable;
        }

        public void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public Integer getSendMsgTimeoutMillis() {
            return this.sendMsgTimeoutMillis;
        }

        public void setSendMsgTimeoutMillis(Integer sendMsgTimeoutMillis) {
            this.sendMsgTimeoutMillis = sendMsgTimeoutMillis;
        }
    }
}

