/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;

@Aspect
public class SleuthMongodbPlugin {
    @Autowired
    private Tracer tracer;
    @Autowired
    private ErrorParser errorParser;

    @Around(value="execution(* org.springframework.data.mongodb.core.MongoOperations.*(..))")
    public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        Class<?> clazz = joinPoint.getTarget().getClass();
        if (!this.tracer.isTracing() || !this.tracer.getCurrentSpan().isExportable()) {
            return joinPoint.proceed();
        }
        Span span = this.tracer.createSpan("mongodb:/" + methodName);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(clazz.getSimpleName()).append(".").append(methodName);
        try {
            span.tag("mongodb.class_method", stringBuilder.toString());
            span.tag("lc", "mongodb");
            span.tag("peer.service", "Mongodb");
            span.logEvent("cs");
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Exception e) {
            this.errorParser.parseErrorTags(span, (Throwable)e);
            throw e;
        }
        finally {
            span.logEvent("cr");
            this.tracer.close(span);
        }
    }
}

