/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.zipkin;

import cn.com.duibaboot.ext.autoconfigure.cloud.zipkin.DuibaTraceSecondFilter;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class DuibaRpcParamsInterceptor
extends HandlerInterceptorAdapter {
    @Autowired
    private Tracer tracer;

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        List argList;
        if (!DuibaTraceSecondFilter.isDebugMode().booleanValue()) {
            return;
        }
        String flages = (String)Optional.ofNullable(request.getAttribute("X-B3-Flags")).orElse("0");
        Span span = this.tracer.getCurrentSpan();
        if (StringUtils.equals((CharSequence)flages, (CharSequence)"1")) {
            JSONObject json = new JSONObject();
            json.putAll(request.getParameterMap());
            json.remove((Object)"_traceMode");
            span.tag("RequestParams", json.toJSONString());
        }
        if ((argList = (List)request.getAttribute("Http-Req-Attr-Rpc-Args")) != null && !argList.isEmpty()) {
            JSONObject json = new JSONObject(argList.size(), true);
            int i = 0;
            for (Object arg : argList) {
                json.put(String.valueOf(i++), (Object)Optional.ofNullable(arg).orElse("null"));
            }
            span.tag("RpcRequestParams", json.toJSONString());
        }
    }
}

