/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import java.lang.instrument.Instrumentation;
import java.util.UUID;
import mockit.Mock;
import mockit.MockUp;
import mockit.internal.startup.Startup;
import net.bytebuddy.agent.ByteBuddyAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplayMockSupport {
    private static final Logger log = LoggerFactory.getLogger(ReplayMockSupport.class);
    private static final long REAL_START_MILLIS = System.currentTimeMillis();
    private static final long REAL_START_NANOS = System.nanoTime();
    private static volatile long OFFSET_MILLIS = 0L;

    private static void init() {
        MockUp<System> systemMockUp = new MockUp<System>(){

            @Mock
            public long currentTimeMillis() {
                return ReplayMockSupport.millisSinceClassInit() + REAL_START_MILLIS + OFFSET_MILLIS;
            }
        };
        MockUp<UUID> uuidMockUp = new MockUp<UUID>(){

            @Mock
            public String toString() {
                return "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%";
            }
        };
    }

    private static long millisSinceClassInit() {
        return (System.nanoTime() - REAL_START_NANOS) / 1000000L;
    }

    public static void setOffsetMillis(long offsetMillis) {
        log.error("setOffsetMillis\u88ab\u6267\u884c,offsetMillis={}", (Object)offsetMillis, (Object)new Exception());
        OFFSET_MILLIS = offsetMillis;
    }

    static {
        if (FlowReplayUtils.isReplayEnv()) {
            Startup.premain(null, (Instrumentation)ByteBuddyAgent.install());
            ReplayMockSupport.init();
        }
    }
}

