/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.BufferedHttpResponseWapper;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayCloseableHttpResponse;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.HttpClientFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.SpanType;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginException;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.message.BasicStatusLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplayHttpClientMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ReplayHttpClientMethodInterceptor.class);

    private boolean canReplay(Method method, Object[] allArguments) {
        if (!"doExecute".equals(method.getName())) {
            return false;
        }
        return FlowReplayUtils.isReplayEnv() && ReplayTraceContext.isReplaying();
    }

    @Override
    public void beforeMethod(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (!this.canReplay(method, allArguments)) {
            return;
        }
        FlowReplaySpan span = ReplayTraceContext.pollSubSpan();
        HttpHost httpHost = (HttpHost)allArguments[0];
        HttpRequest httpRequest = (HttpRequest)allArguments[1];
        HttpClientFlowReplaySpan replayDetailSpan = this.createReplayDetailSpan(httpHost, httpRequest, span);
        if (span == null || SpanType.HTTP_CLIENT != span.getSpanType()) {
            String expert = SpanType.HTTP_CLIENT.name();
            String actual = span != null ? span.getSpanType().name() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        HttpClientFlowReplaySpan httpClientSpan = (HttpClientFlowReplaySpan)span;
        String currentHttpMethod = HttpClientFlowReplaySpan.parseMethod(httpRequest);
        String currentUrl = HttpClientFlowReplaySpan.parseUrl(httpHost, httpRequest);
        Map<String, List<String>> currentParameters = HttpClientFlowReplaySpan.parseRequestParameters(httpRequest);
        byte[] currentRequestBody = HttpClientFlowReplaySpan.parseRequestBody(httpRequest);
        if (!httpClientSpan.getMethod().equals(currentHttpMethod)) {
            String expert = httpClientSpan.getMethod();
            String actual = currentHttpMethod;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_1011, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        URI uriRecord = new URI(httpClientSpan.getUrl());
        URI uriReplay = new URI(currentUrl);
        if (!uriRecord.getPath().equals(uriReplay.getPath()) || !Objects.equals(uriRecord.getQuery(), uriReplay.getQuery())) {
            String expert = httpClientSpan.getUrl();
            String actual = currentUrl;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_1012, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        if (!this.isParametersEqual(httpClientSpan.getRequestParameters(), currentParameters)) {
            String expert = httpClientSpan.getRequestParameters() != null ? httpClientSpan.getRequestParameters().toString() : null;
            String actual = currentParameters.toString();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_1013, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        if (!Arrays.equals(httpClientSpan.getRequestBody(), currentRequestBody)) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_1014);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        ProtocolVersion version = new ProtocolVersion(httpClientSpan.getProtocol(), httpClientSpan.getMajor(), httpClientSpan.getMinor());
        BasicStatusLine statusLine = new BasicStatusLine(version, httpClientSpan.getStatusCode(), httpClientSpan.getReasonPhrase());
        ReplayCloseableHttpResponse mockResp = new ReplayCloseableHttpResponse(httpClientSpan.getResponseBody(), httpClientSpan.getResponseHeaders(), (StatusLine)statusLine);
        BufferedHttpResponseWapper mockRespWapper = new BufferedHttpResponseWapper(mockResp);
        replayDetailSpan.setResp(mockRespWapper);
        result.defineReturnValue(mockRespWapper);
    }

    private HttpClientFlowReplaySpan createReplayDetailSpan(HttpHost httpHost, HttpRequest httpRequest, FlowReplaySpan span) {
        HttpClientFlowReplaySpan replayDetailSpan = null;
        try {
            replayDetailSpan = HttpClientFlowReplaySpan.createSpan(httpHost, httpRequest, null);
            replayDetailSpan.setTraceId(FlowReplayTrace.getCurrentTraceId());
            if (span != null) {
                replayDetailSpan.setSpanId(span.getSpanId());
            }
            FlowReplayTrace.addSubSpan(replayDetailSpan);
        }
        catch (IOException e) {
            throw new PluginException("\u6b63\u5e38\u8fd9\u4e2a\u5f02\u5e38\u4e0d\u53ef\u80fd\u51fa\u6765...HttpClientFlowReplaySpan.createSpan(),\u7b2c\u4e09\u4e2a\u53c2\u6570\u4e0d\u4e3a\u7a7a\u624d\u6709\u53ef\u80fd", e);
        }
        return replayDetailSpan;
    }

    @Override
    public Object afterMethod(Object zuperCall, Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    @Override
    public void handleMethodException(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }

    private boolean isParametersEqual(Map<String, List<String>> recordParameters, Map<String, List<String>> currentParameters) {
        Preconditions.checkNotNull(recordParameters, (Object)"recordParameters can't be null");
        Preconditions.checkNotNull(currentParameters, (Object)"currentParameters can't be null");
        if (recordParameters.size() != currentParameters.size()) {
            return false;
        }
        for (Map.Entry<String, List<String>> entry : recordParameters.entrySet()) {
            String k = entry.getKey();
            List<String> v = entry.getValue();
            List<String> cv = currentParameters.get(k);
            if (v == null && cv == null) continue;
            if (v == null || cv == null) {
                return false;
            }
            if (CollectionUtils.isEqualCollection(v, cv)) continue;
            return false;
        }
        return true;
    }
}

