/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.esotericsoftware.kryo.Kryo;
import shaded.com.esotericsoftware.kryo.Registration;
import shaded.com.esotericsoftware.kryo.factories.ReflectionSerializerFactory;
import shaded.com.esotericsoftware.kryo.io.Input;
import shaded.com.esotericsoftware.kryo.io.Output;
import shaded.com.esotericsoftware.kryo.serializers.CompatibleFieldSerializer;

public class KryoSerializer {
    private static final Logger log = LoggerFactory.getLogger(KryoSerializer.class);
    private static final int BUFFER_SIZE = 16384;
    private static final Class<?> ARRAY_AS_LIST;
    private static final Class<?> UNMODIFIABLE_COLLECTION;
    private static final Class<?> UNMODIFIABLE_LIST;
    private static final Class<?> UNMODIFIABLE_MAP;
    private static final Class<?> UNMODIFIABLE_NAVIGABLEMAP;
    private static final Class<?> UNMODIFIABLE_NAVIGABLESET;
    private static final Class<?> UNMODIFIABLE_RANDOMACCESSLIST;
    private static final Class<?> UNMODIFIABLE_SET;
    private static final Class<?> UNMODIFIABLE_SORTEDMAP;
    private static final Class<?> UNMODIFIABLE_SORTEDSET;
    private static ThreadLocal<Kryo> kryoThreadLocal;

    private KryoSerializer() {
    }

    public static Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        Kryo kryo = kryoThreadLocal.get();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        Input input = new Input(in, 16384);
        Object obj = kryo.readClassAndObject(input);
        input.close();
        return obj;
    }

    public static byte[] serialize(Object object) {
        if (object == null) {
            return null;
        }
        Kryo kryo = kryoThreadLocal.get();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Output output = new Output(out, 16384);
        kryo.writeClassAndObject(output, object);
        output.close();
        return out.toByteArray();
    }

    static {
        try {
            ARRAY_AS_LIST = Class.forName("java.util.Arrays$ArrayList");
            UNMODIFIABLE_COLLECTION = Class.forName("java.util.Collections$UnmodifiableCollection");
            UNMODIFIABLE_LIST = Class.forName("java.util.Collections$UnmodifiableList");
            UNMODIFIABLE_MAP = Class.forName("java.util.Collections$UnmodifiableMap");
            UNMODIFIABLE_NAVIGABLEMAP = Class.forName("java.util.Collections$UnmodifiableNavigableMap");
            UNMODIFIABLE_NAVIGABLESET = Class.forName("java.util.Collections$UnmodifiableNavigableSet");
            UNMODIFIABLE_RANDOMACCESSLIST = Class.forName("java.util.Collections$UnmodifiableRandomAccessList");
            UNMODIFIABLE_SET = Class.forName("java.util.Collections$UnmodifiableSet");
            UNMODIFIABLE_SORTEDMAP = Class.forName("java.util.Collections$UnmodifiableSortedMap");
            UNMODIFIABLE_SORTEDSET = Class.forName("java.util.Collections$UnmodifiableSortedSet");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("should not be here", e);
        }
        kryoThreadLocal = ThreadLocal.withInitial(() -> {
            Kryo kryo = new Kryo(){

                @Override
                public Registration writeClass(Output output, Class type) {
                    if (type == ARRAY_AS_LIST) {
                        type = ArrayList.class;
                    } else if (type == UNMODIFIABLE_COLLECTION) {
                        type = ArrayList.class;
                    } else if (type == UNMODIFIABLE_LIST) {
                        type = ArrayList.class;
                    } else if (type == UNMODIFIABLE_MAP) {
                        type = HashMap.class;
                    } else if (type == UNMODIFIABLE_NAVIGABLEMAP) {
                        type = ConcurrentSkipListMap.class;
                    } else if (type == UNMODIFIABLE_NAVIGABLESET) {
                        type = ConcurrentSkipListSet.class;
                    } else if (type == UNMODIFIABLE_RANDOMACCESSLIST) {
                        type = ArrayList.class;
                    } else if (type == UNMODIFIABLE_SET) {
                        type = HashSet.class;
                    } else if (type == UNMODIFIABLE_SORTEDMAP) {
                        type = ConcurrentSkipListMap.class;
                    } else if (type == UNMODIFIABLE_SORTEDSET) {
                        type = ConcurrentSkipListSet.class;
                    }
                    return super.writeClass(output, type);
                }
            };
            kryo.setDefaultSerializer(new ReflectionSerializerFactory(CompatibleFieldSerializer.class));
            kryo.setInstantiatorStrategy(new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
            return kryo;
        });
    }
}

