/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.span;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.SpanType;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.StandardSpan;
import com.google.common.base.Optional;
import java.lang.reflect.Method;

public class GuavaCacheFlowReplaySpan
extends StandardSpan {
    private static final long serialVersionUID = 2104265694610835781L;
    private boolean guavaOptionalReturnValue = false;
    private boolean javaOptionalReturnValue = false;

    @Override
    public SpanType getSpanType() {
        return SpanType.GUAVA_CACHE;
    }

    public static GuavaCacheFlowReplaySpan createSpan(Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        String[] parameterTypes = null;
        Class<?>[] argumentsTypesTemp = GuavaCacheFlowReplaySpan.customizeArgumentsTypes(method, argumentsTypes);
        if (argumentsTypesTemp.length > 0) {
            parameterTypes = new String[argumentsTypesTemp.length];
            for (int i = 0; i < argumentsTypesTemp.length; ++i) {
                parameterTypes[i] = argumentsTypesTemp[i].getName();
            }
        }
        GuavaCacheFlowReplaySpan span = new GuavaCacheFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.setMethodName(method.getName());
        span.setParameterTypes(parameterTypes);
        span.setParameterValues(GuavaCacheFlowReplaySpan.customizeParameterValues(method, allArguments));
        span.setRet(method, ret);
        return span;
    }

    public void setRet(Method method, Object ret) {
        this.setReturnType(method.getReturnType().getName());
        if (ret == null) {
            return;
        }
        Object retTemp = null;
        if (ret instanceof java.util.Optional) {
            java.util.Optional optional = (java.util.Optional)ret;
            if (optional.isPresent()) {
                retTemp = optional.get();
            }
            this.javaOptionalReturnValue = true;
        } else if (ret instanceof Optional) {
            Optional optional = (Optional)ret;
            if (optional.isPresent()) {
                retTemp = optional.get();
            }
            this.guavaOptionalReturnValue = true;
        } else {
            retTemp = ret;
        }
        this.setReturnValue(retTemp);
    }

    public static Class<?>[] customizeArgumentsTypes(Method method, Class<?>[] argumentsTypes) {
        if ("get".equals(method.getName())) {
            return new Class[]{argumentsTypes[0]};
        }
        return argumentsTypes;
    }

    public static Object[] customizeParameterValues(Method method, Object[] parameterValues) {
        if ("get".equals(method.getName())) {
            return new Object[]{parameterValues[0]};
        }
        return parameterValues;
    }

    @Override
    public Object getReturnValue() {
        Object ret = super.getReturnValue();
        if (this.javaOptionalReturnValue) {
            return java.util.Optional.ofNullable(ret);
        }
        if (this.guavaOptionalReturnValue) {
            return Optional.fromNullable((Object)ret);
        }
        return ret;
    }
}

