/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.httpclient;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.httpclient.HttpClientMethodInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Resource;
import org.aopalliance.aop.Advice;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class HttpClientAopPostProcessor
implements SpecifiedBeanPostProcessor<CloseableHttpClient> {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientAopPostProcessor.class);
    @Resource
    private ApplicationContext applicationContext;

    @Override
    public Class<CloseableHttpClient> getBeanType() {
        return CloseableHttpClient.class;
    }

    @Override
    public Object postProcessBeforeInitialization(CloseableHttpClient bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(CloseableHttpClient bean, String beanName) throws BeansException {
        ArrayList interceptors = new ArrayList(this.applicationContext.getBeansOfType(HttpClientMethodInterceptor.class).values());
        if (interceptors.isEmpty()) {
            logger.warn("\u6ca1\u6709\u627e\u5230HttpClientMethodInterceptor\u7684\u5b9e\u73b0\uff0c\u4e0d\u4f1a\u7ed9httpClient\u9644\u52a0aop");
            return bean;
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTarget((Object)bean);
        Collections.sort(interceptors, (o1, o2) -> o1.getOrder() - o2.getOrder());
        for (HttpClientMethodInterceptor interceptor : interceptors) {
            proxyFactory.addAdvice((Advice)interceptor);
        }
        return proxyFactory.getProxy();
    }

    public int getOrder() {
        return 0;
    }
}

